<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User\Mantu;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method userLikeByParams(array $params)
 * @method cancelUserLikeByParams(array $params)
 * @method userLikeListByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 */
class MantuCustomerPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户收藏客片
     *
     * @support  int $customerPhotoId 客片id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function userLike ($context) {
        return self::getClass()->userLike([
            "context" => $context,
        ]);
    }

    /**
     * 用户取消收藏客片
     *
     * @support  int $customerPhotoId 客片id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelUserLike ($context) {
        return self::getClass()->cancelUserLike([
            "context" => $context,
        ]);
    }

    /**
     * 用户收藏列表
     *
     * @support  int $pageSize 单页数量 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function userLikeList ($context) {
        return self::getClass()->userLikeList([
            "context" => $context,
        ]);
    }

    /**
     * 客片列表
     *
     * @support  int $storeId 门店id [ require false ]
     * @support  int $pageSize 单页数量 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list ($context) {
        return self::getClass()->list([
            "context" => $context,
        ]);
    }

    /**
     * 客片详情
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail ($context) {
        return self::getClass()->detail([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\Mantu\MantuCustomerPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\Mantu\MantuCustomerPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}