<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method allByParams(array $params)
 * @method deleteByParams(array $params)
 */
class ServiceGroupTemplete {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建服务组模板
     *
     * @param  string $name 模板名称 [ require true ]
     * @param  string $module 所属模块 [ require true ]
     * @param  string $content 模板内容 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name, string $module, string $content = '') {
        return self::getClass()->create([
            "name" => $name,
            "module" => $module,
            "content" => $content,
        ]);
    }

    /**
     * 更新服务组模板
     *
     * @param  int $id 模板id [ require true ]
     * @support  string $name 模板名称 [ require false ]
     * @support  string $module 所属模块 [ require false ]
     * @support  string $content 模板内容 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update ($context, int $id) {
        return self::getClass()->update([
            "context" => $context,
            "id" => $id,
        ]);
    }

    /**
     * 获取服务组模板
     *
     * @param  string $module 模块 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function all (string $module = '') {
        return self::getClass()->all([
            "module" => $module,
        ]);
    }

    /**
     * 删除服务组模板
     *
     * @param  int $id 模板id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ServiceGroupTemplete');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ServiceGroupTemplete');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}