<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchCreateByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method createLogListByParams(array $params)
 * @method abolishByParams(array $params)
 * @method getLogsByParams(array $params)
 */
class ProductCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 管理端生成产品卡
     *
     * @support  string $title 标题 [ require true ]
     * @support  int $template_id 模板id [ require true ]
     * @support  int $count 创建数量 [ require false ]
     * @support  string $apply_in 应用于 [ require false ]
     * @support  int $validity_period 有效期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate ($context) {
        return self::getClass()->batchCreate([
            "context" => $context,
        ]);
    }

    /**
     * 获取产品卡列表(分页)
     *
     * @support  int $id 产品卡编号 [ require false ]
     * @support  string $mobile 手机号 [ require false ]
     * @support  int $user_id 用户id [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $code 兑换码 [ require false ]
     * @support  string $apply_in 应用于 [ require false ]
     * @support  bool $with_template_info 包含卡面信息 [ require false ]
     * @support  int $create_log_id 记录id [ require false ]
     * @support  string $created_at_start 创建时间起 [ require false ]
     * @support  string $created_at_end 创建时间止 [ require false ]
     * @support  string $used_at_start 使用时间起 [ require false ]
     * @support  string $used_at_end 使用时间止 [ require false ]
     * @support  int $product_id 适用产品 [ require false ]
     * @support  int $store_id 适用门店 [ require false ]
     * @support  bool $action_scope 是否可以用于升级服务 [ require false ]
     * @support  string $description 描述 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list ($context) {
        return self::getClass()->list([
            "context" => $context,
        ]);
    }

    /**
     * 获取兑换码列表(所有)
     *
     * @support  string $mobile 手机号 [ require false ]
     * @support  string $created_at_start 生成时间起 [ require false ]
     * @support  string $created_at_end 生成时间止 [ require false ]
     * @support  string $used_at_start 使用时间起 [ require false ]
     * @support  string $used_at_end 使用时间止 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $apply_in 应用于 [ require false ]
     * @support  string $code 兑换码 [ require false ]
     * @support  int $create_log_id 创建记录id [ require false ]
     * @support  bool $with_template_info 包含卡面信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function all ($context) {
        return self::getClass()->all([
            "context" => $context,
        ]);
    }

    /**
     * 产品券渠道领券查询
     *
     * @support  int $channel 渠道号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createLogList ($context) {
        return self::getClass()->createLogList([
            "context" => $context,
        ]);
    }

    /**
     * 作废产品卡
     *
     * @support  array $codes 码数组 [ require false ]
     * @support  array $ids ids数组 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function abolish ($context) {
        return self::getClass()->abolish([
            "context" => $context,
        ]);
    }

    /**
     * 产品券创建记录查询
     *
     * @support  array $ids 记录ids [ require false ]
     * @support  string $created_at_end 创建时间止 [ require false ]
     * @support  string $created_at_start 创建时间起 [ require false ]
     * @support  bool $with_template_info 包含模板信息 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @support  string $apply_in 应用于 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLogs ($context) {
        return self::getClass()->getLogs([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}