<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hotWordListByParams(array $params)
 * @method hotWordEditByParams(array $params)
 * @method recommendListByParams(array $params)
 * @method recommendEditByParams(array $params)
 */
class SearchConfig {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取热词配置列表
     *
     * @support  int $is_overhead 是否获取推荐 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hotWordList ($context) {
        return self::getClass()->hotWordList([
            "context" => $context,
        ]);
    }

    /**
     * 编辑热词配置
     *
     * @support  array $data data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hotWordEdit ($context) {
        return self::getClass()->hotWordEdit([
            "context" => $context,
        ]);
    }

    /**
     * 获取为我推荐配置列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function recommendList ($context) {
        return self::getClass()->recommendList();
    }

    /**
     * 编辑为我推荐配置
     *
     * @support  array $data data [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function recommendEdit ($context) {
        return self::getClass()->recommendEdit([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\SearchConfig');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\SearchConfig');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}