<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method passByParams(array $params)
 * @method deleteByParams(array $params)
 * @method offShelfByParams(array $params)
 * @method onShelfByParams(array $params)
 * @method downloadByParams(array $params)
 * @method orderPhotoByParams(array $params)
 */
class SamplePhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建样片
     *
     * @support  string $brand 品牌 [ require true ]
     * @support  array $label 标签 [ require true ]
     * @support  string $type 样片类型 [ require true ]
     * @support  string $name 样片名称 [ require true ]
     * @support  string $expired_at 过期时间 [ require true ]
     * @support  array $images 样片地址 [ require true ]
     * @support  string $evidence 凭证地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create ($context) {
        return self::getClass()->create([
            "context" => $context,
        ]);
    }

    /**
     * 获取样片列表
     *
     * @support  int $id 样片的id [ require false ]
     * @support  string $brand 品牌 [ require false ]
     * @support  int $product_id 产品id [ require false ]
     * @support  array $label 标签 [ require false ]
     * @support  string $name 样片名称 [ require false ]
     * @support  int $expired_days 过期查询天数 [ require false ]
     * @support  string $type 类型 [ require false ]
     * @support  string $uper 上传人 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list ($context) {
        return self::getClass()->list([
            "context" => $context,
        ]);
    }

    /**
     * 获取样片详情
     *
     * @support  int $id 样片id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail ($context) {
        return self::getClass()->detail([
            "context" => $context,
        ]);
    }

    /**
     * 审核通过
     *
     * @support  int $id 样片id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pass ($context) {
        return self::getClass()->pass([
            "context" => $context,
        ]);
    }

    /**
     * 移除客片
     *
     * @support  int $id 样片id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete ($context) {
        return self::getClass()->delete([
            "context" => $context,
        ]);
    }

    /**
     * 下架样片
     *
     * @support  int $id 样片id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offShelf ($context) {
        return self::getClass()->offShelf([
            "context" => $context,
        ]);
    }

    /**
     * 上架样片
     *
     * @support  int $id 样片id [ require true ]
     * @support  string $expired_at 过期时间 [ require true ]
     * @support  string $evidence 凭证地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onShelf ($context) {
        return self::getClass()->onShelf([
            "context" => $context,
        ]);
    }

    /**
     * 下载样片
     *
     * @support  int $id 样片id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function download ($context) {
        return self::getClass()->download([
            "context" => $context,
        ]);
    }

    /**
     * 订单客片
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderPhoto ($context) {
        return self::getClass()->orderPhoto([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\SamplePhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\SamplePhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}