<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getMaterialInfoByParams(array $params)
 * @method createAliasByParams(array $params)
 * @method removeAliasByParams(array $params)
 * @method getSkuNameListByParams(array $params)
 * @method getLabelListByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailBySkuByParams(array $params)
 * @method detailByIdsByParams(array $params)
 * @method upProductByParams(array $params)
 * @method downProductByParams(array $params)
 * @method batchUpProductByParams(array $params)
 * @method batchDownProductByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method getProductListByParams(array $params)
 * @method getDetailByCodeByParams(array $params)
 * @method getStoreGroupListByParams(array $params)
 * @method createStoreGroupByParams(array $params)
 * @method editStoreGroupByParams(array $params)
 * @method removeStoreGroupByParams(array $params)
 * @method groupBindStoreByParams(array $params)
 * @method getGroupDetailByParams(array $params)
 * @method getAllRetailProductByParams(array $params)
 */
class RetailProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建零售产品
     *
     * @support  string $name 产品名称 [ require true ]
     * @support  int $category_id 产品品类ID [ require true ]
     * @support  string $main_img 产品主图地址 [ require false ]
     * @support  array $sku_basic 产品规格 [ require true ]
     * @support  array $sku 规格详情 [ require true ]
     * @support  array $store_group 城市组 [ require false ]
     * @support  int $online_sales 线上销售:1 是 0 否 [ require true ]
     * @support  int $offline_sales 线下销售 [ require true ]
     * @support  int $alias_id 别名id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create ($context) {
        return self::getClass()->create([
            "context" => $context,
        ]);
    }

    /**
     * 获取物料信息
     *
     * @support  string $name 物料名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMaterialInfo ($context) {
        return self::getClass()->getMaterialInfo([
            "context" => $context,
        ]);
    }

    /**
     * 添加产品别名
     *
     * @support  string $name 别名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createAlias ($context) {
        return self::getClass()->createAlias([
            "context" => $context,
        ]);
    }

    /**
     * 删除产品别名
     *
     * @support  int $id 别名id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeAlias ($context) {
        return self::getClass()->removeAlias([
            "context" => $context,
        ]);
    }

    /**
     * 获取规格名列表
     *
     * @support  string $name 规格名 [ require false ]
     * @support  bool $withLabel 是否需要规格值 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuNameList ($context) {
        return self::getClass()->getSkuNameList([
            "context" => $context,
        ]);
    }

    /**
     * 获取规格值列表
     *
     * @support  string $name 规格值名称 [ require false ]
     * @support  int $groupId 规格名id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLabelList ($context) {
        return self::getClass()->getLabelList([
            "context" => $context,
        ]);
    }

    /**
     * 编辑零售产品
     *
     * @support  int $id 产品ID [ require true ]
     * @support  string $name 产品名称 [ require true ]
     * @support  int $category_id 产品品类ID [ require true ]
     * @support  string $main_img 产品主图地址 [ require false ]
     * @support  array $sku_basic 产品规格 [ require true ]
     * @support  array $sku 规格详情 [ require true ]
     * @support  int $sku_id sku id [ require false ]
     * @support  array $store_group 城市组 [ require false ]
     * @support  int $online_sales 线上销售:1 是 0 否 [ require true ]
     * @support  int $offline_sales 线下销售 [ require true ]
     * @support  int $alias_id 别名id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update ($context) {
        return self::getClass()->update([
            "context" => $context,
        ]);
    }

    /**
     * 产品详情
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 根据sku获取产品详情
     *
     * @param  int $id sku id [ require true ]
     * @param  bool $withOffSku 是否获取下架的sku [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailBySku (int $id, bool $withOffSku = false) {
        return self::getClass()->detailBySku([
            "id" => $id,
            "withOffSku" => $withOffSku,
        ]);
    }

    /**
     * 批量产品详情
     *
     * @param  array $ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detailByIds (array $ids) {
        return self::getClass()->detailByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 上架产品
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upProduct ($context, int $id) {
        return self::getClass()->upProduct([
            "context" => $context,
            "id" => $id,
        ]);
    }

    /**
     * 下架产品
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function downProduct ($context, int $id) {
        return self::getClass()->downProduct([
            "context" => $context,
            "id" => $id,
        ]);
    }

    /**
     * 批量上架产品
     *
     * @param  array $ids 产品IDS [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpProduct ($context, array $ids) {
        return self::getClass()->batchUpProduct([
            "context" => $context,
            "ids" => $ids,
        ]);
    }

    /**
     * 批量下架产品
     *
     * @param  array $ids 产品IDS [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchDownProduct ($context, array $ids) {
        return self::getClass()->batchDownProduct([
            "context" => $context,
            "ids" => $ids,
        ]);
    }

    /**
     * 删除产品
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove ($context, int $id) {
        return self::getClass()->remove([
            "context" => $context,
            "id" => $id,
        ]);
    }

    /**
     * 产品分页列表
     *
     * @support  int $page 当前页 [ require false ]
     * @support  int $page_size 页内条数 [ require false ]
     * @support  string $name 名称(模糊查询) [ require false ]
     * @support  int $category_id 品类ID [ require false ]
     * @support  string $status 产品状态 [ require false ]
     * @support  int $online_sales 线上1, 否则0 [ require false ]
     * @support  int $offline_sales 线下1, 否则0 [ require false ]
     * @support  bool $show_deleted 是否显示已删除信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list ($context) {
        return self::getClass()->list([
            "context" => $context,
        ]);
    }

    /**
     * 产品列表
     *
     * @support  string $name 名称(模糊查询) [ require false ]
     * @support  int $category_id 品类ID [ require false ]
     * @support  string $status 产品状态 [ require false ]
     * @support  bool $show_deleted 是否显示已删除信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function all ($context) {
        return self::getClass()->all([
            "context" => $context,
        ]);
    }

    /**
     * 查询零售产品列表
     *
     * @support  int $store_id 门店id [ require false ]
     * @support  array $sku_ids sku_ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductList ($context) {
        return self::getClass()->getProductList([
            "context" => $context,
        ]);
    }

    /**
     * 通过产品编码获取产品详情
     *
     * @param  string $product_code 产品编码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDetailByCode (string $product_code) {
        return self::getClass()->getDetailByCode([
            "product_code" => $product_code,
        ]);
    }

    /**
     * 获取城市组列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreGroupList ($context) {
        return self::getClass()->getStoreGroupList();
    }

    /**
     * 创建城市组
     *
     * @support  string $name 分组名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStoreGroup ($context) {
        return self::getClass()->createStoreGroup([
            "context" => $context,
        ]);
    }

    /**
     * 修改城市组名
     *
     * @support  string $name 分组名称 [ require true ]
     * @support  int $id 分组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editStoreGroup ($context) {
        return self::getClass()->editStoreGroup([
            "context" => $context,
        ]);
    }

    /**
     * 删除城市组
     *
     * @support  int $id 分组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeStoreGroup ($context) {
        return self::getClass()->removeStoreGroup([
            "context" => $context,
        ]);
    }

    /**
     * 城市组绑定店铺
     *
     * @support  int $id 城市组id [ require true ]
     * @support  string $name 城市组名称 [ require true ]
     * @support  array $storeIds 门店组 [ require false ]
     * @support  array $ruleInfo 规则详情。moduleName: himo_blue,himo_gold,himo_kids,mainto [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function groupBindStore ($context) {
        return self::getClass()->groupBindStore([
            "context" => $context,
        ]);
    }

    /**
     * 获取城市组详情
     *
     * @param  int $id 城市组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupDetail (int $id) {
        return self::getClass()->getGroupDetail([
            "id" => $id,
        ]);
    }

    /**
     * 获取全部零售产品
     *
     * @support  string $name 名称(模糊查询) [ require false ]
     * @support  int $category_id 分类ID [ require false ]
     * @support  bool $show_deleted 是否显示已删除信息 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  array $store_ids 店铺ids [ require false ]
     * @support  array $area_ids 城市ids [ require false ]
     * @support  string $store_type 门店类型 [ require false ]
     * @support  string $from 查询来源 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllRetailProduct ($context) {
        return self::getClass()->getAllRetailProduct([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\RetailProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\RetailProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}