<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method createByParams(array $params)
 * @method backByParams(array $params)
 * @method getByParams(array $params)
 * @method doneByParams(array $params)
 * @method deleteByParams(array $params)
 * @method detailByParams(array $params)
 */
class RentalLog {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 门店租金查询
     *
     * @support  int $store_id 门店id [ require false ]
     * @support  string $pay_time_start 打款的开始时间 [ require false ]
     * @support  string $pay_time_end 打款的结束时间 [ require false ]
     * @support  string $state 状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list ($context) {
        return self::getClass()->list([
            "context" => $context,
        ]);
    }

    /**
     * 门店租金缴纳
     *
     * @support  int $store_id 门店id [ require true ]
     * @support  float $money 总金额 [ require true ]
     * @support  string $pay_time 最晚支付时间 [ require true ]
     * @support  string $image 缴费单图片地址 [ require true ]
     * @support  array $fixed_rent 固定租金 [ require false ]
     * @support  array $property 物业费 [ require false ]
     * @support  array $promotion 推广费 [ require false ]
     * @support  array $more 其他费用 [ require false ]
     * @support  string $state 状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create ($context) {
        return self::getClass()->create([
            "context" => $context,
        ]);
    }

    /**
     * 标记退回
     *
     * @support  string $_id 缴费id [ require true ]
     * @support  string $state 标记状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function back ($context) {
        return self::getClass()->back([
            "context" => $context,
        ]);
    }

    /**
     * 标记收到
     *
     * @support  string $_id 缴费id [ require true ]
     * @support  string $state 标记状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function get ($context) {
        return self::getClass()->get([
            "context" => $context,
        ]);
    }

    /**
     * 标记冲账
     *
     * @support  string $_id 缴费id [ require true ]
     * @support  string $state 标记状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function done ($context) {
        return self::getClass()->done([
            "context" => $context,
        ]);
    }

    /**
     * 删除操作
     *
     * @support  string $_id 缴费id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete ($context) {
        return self::getClass()->delete([
            "context" => $context,
        ]);
    }

    /**
     * 详情
     *
     * @support  string $_id 缴费id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail ($context) {
        return self::getClass()->detail([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\RentalLog');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\RentalLog');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}