<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method storeProductByParams(array $params)
 * @method infoByParams(array $params)
 * @method batchDetailByParams(array $params)
 * @method storeProductDetailByParams(array $params)
 */
class ProductStore {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店所有产品
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeProduct ($context) {
        return self::getClass()->storeProduct();
    }

    /**
     * 获取产品详情
     *
     * @support  int $product_id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function info ($context) {
        return self::getClass()->info([
            "context" => $context,
        ]);
    }

    /**
     * 批量获取多个产品详情
     *
     * @support  array $product_ids 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchDetail ($context) {
        return self::getClass()->batchDetail([
            "context" => $context,
        ]);
    }

    /**
     * 获取产品/服务详情
     *
     * @param  int $product_id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeProductDetail (int $product_id) {
        return self::getClass()->storeProductDetail([
            "product_id" => $product_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductStore');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductStore');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}