<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSkuNameListByParams(array $params)
 * @method detailByParams(array $params)
 * @method getProductListByParams(array $params)
 * @method getProductListV2ByParams(array $params)
 * @method getDetailByCodeByParams(array $params)
 * @method getStoreGroupListByParams(array $params)
 * @method createStoreGroupByParams(array $params)
 * @method editStoreGroupByParams(array $params)
 * @method removeStoreGroupByParams(array $params)
 * @method groupBindStoreByParams(array $params)
 * @method getGroupDetailByParams(array $params)
 * @method getAllRetailProductByParams(array $params)
 */
class RetailProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取规格名列表
     *
     * @support  string $name 规格名 [ require false ]
     * @support  bool $withLabel 是否需要规格值 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuNameList ($context) {
        return self::getClass()->getSkuNameList([
            "context" => $context,
        ]);
    }

    /**
     * 产品详情
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 查询零售产品列表
     *
     * @support  int $store_id 门店id [ require false ]
     * @support  array $sku_ids sku_ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductList ($context) {
        return self::getClass()->getProductList([
            "context" => $context,
        ]);
    }

    /**
     * 查询零售产品列表V2
     *
     * @support  array $ids 渠道productSkuId数组 [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @support  int $sellChannelId 销售渠道id [ require false ]
     * @support  array $categoryIds 销售渠道productSkuId数组 [ require false ]
     * @support  string $skuName 销售渠道skuName [ require false ]
     * @support  string $skuCode 销售渠道skuCode [ require false ]
     * @support  bool $isOnlyShelveUp true查询上架的sku，false查询上架和下架的sku [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductListV2 ($context) {
        return self::getClass()->getProductListV2([
            "context" => $context,
        ]);
    }

    /**
     * 通过产品编码获取产品详情
     *
     * @param  string $product_code 产品编码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDetailByCode (string $product_code) {
        return self::getClass()->getDetailByCode([
            "product_code" => $product_code,
        ]);
    }

    /**
     * 获取城市组列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreGroupList ($context) {
        return self::getClass()->getStoreGroupList();
    }

    /**
     * 创建城市组
     *
     * @support  string $name 分组名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStoreGroup ($context) {
        return self::getClass()->createStoreGroup([
            "context" => $context,
        ]);
    }

    /**
     * 修改城市组名
     *
     * @support  string $name 分组名称 [ require true ]
     * @support  int $id 分组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editStoreGroup ($context) {
        return self::getClass()->editStoreGroup([
            "context" => $context,
        ]);
    }

    /**
     * 删除城市组
     *
     * @support  int $id 分组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeStoreGroup ($context) {
        return self::getClass()->removeStoreGroup([
            "context" => $context,
        ]);
    }

    /**
     * 城市组绑定店铺
     *
     * @support  int $id 城市组id [ require true ]
     * @support  string $name 城市组名称 [ require true ]
     * @support  array $storeIds 门店组 [ require false ]
     * @support  array $ruleInfo 规则详情。moduleName: himo_blue,himo_gold,himo_kids,mainto [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function groupBindStore ($context) {
        return self::getClass()->groupBindStore([
            "context" => $context,
        ]);
    }

    /**
     * 获取城市组详情
     *
     * @param  int $id 城市组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupDetail (int $id) {
        return self::getClass()->getGroupDetail([
            "id" => $id,
        ]);
    }

    /**
     * 获取全部零售产品
     *
     * @support  array $ids 渠道productSkuId数组 [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @support  int $sellChannelId 销售渠道id [ require false ]
     * @support  array $categoryIds 销售渠道productSkuId数组 [ require false ]
     * @support  string $skuName 销售渠道skuName [ require false ]
     * @support  string $skuCode 销售渠道skuCode [ require false ]
     * @support  bool $isOnlyShelveUp true查询上架的sku，false查询上架和下架的sku [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllRetailProduct ($context) {
        return self::getClass()->getAllRetailProduct([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\RetailProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\RetailProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}