<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method createInvoiceByParams(array $params)
 * @method reopenByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailRefitByParams(array $params)
 * @method deleteByParams(array $params)
 * @method completeByParams(array $params)
 * @method listByParams(array $params)
 * @method cronSubmitFinalCommitByParams(array $params)
 * @method invalidByParams(array $params)
 * @method reviewFailedByParams(array $params)
 * @method resendByParams(array $params)
 * @method invoiceListByParams(array $params)
 * @method invoiceSubjectByParams(array $params)
 * @method canInvoiceListByParams(array $params)
 */
class Invoice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 开具发票
     *
     * @support  string $invoice_belong 发票归属(himo|gift_card|product_card|other) [ require false ]
     * @support  string $invoice_type 发票类型(paper|electronic) [ require false ]
     * @support  string $title_type 抬头类型(person|company) [ require false ]
     * @support  string $type 抬头类型(normal|professional) [ require false ]
     * @support  bool $is_now 是否立即开具 [ require false ]
     * @support  string $name 购方名称 [ require true ]
     * @support  string $phone 购方手机 (开票成功会短信提醒购方) [ require false ]
     * @support  string $taxnum 购方税号(18/20位) [ require false ]
     * @support  array $order_nums 订单编号 [ require false ]
     * @support  array $detail 电子发票明细 [ require true ]
     * @support  string $telephone 购方电话 [ require false ]
     * @support  string $address 购方地址 [ require false ]
     * @support  string $account 购方银行账号(和开户行合在一起) [ require false ]
     * @support  string $email 推送邮箱 [ require false ]
     * @support  string $message 备注信息 [ require false ]
     * @support  string $delivery_area 收货省市区信息 [ require false ]
     * @support  string $delivery_address 收货详细地址信息 [ require false ]
     * @support  string $delivery_people 收货人 [ require false ]
     * @support  string $delivery_phone 收货手机 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create ($context) {
        return self::getClass()->create([
            "context" => $context,
        ]);
    }

    /**
     * 开具发票(RPC调用)
     *
     * @support  string $invoice_belong 发票归属(himo|gift_card|product_card|other) [ require false ]
     * @support  string $invoice_type 发票类型(paper|electronic) [ require false ]
     * @support  string $title_type 抬头类型(person|company) [ require false ]
     * @support  string $type 抬头类型(normal|professional) [ require false ]
     * @support  bool $is_now 是否立即开具 [ require false ]
     * @support  string $name 购方名称 [ require true ]
     * @support  string $phone 购方手机 (开票成功会短信提醒购方) [ require false ]
     * @support  string $taxnum 购方税号(18/20位) [ require false ]
     * @support  array $order_nums 订单编号 [ require false ]
     * @support  array $detail 电子发票明细 [ require true ]
     * @support  string $telephone 购方电话 [ require false ]
     * @support  string $address 购方地址 [ require false ]
     * @support  string $account 购方银行账号(和开户行合在一起) [ require false ]
     * @support  string $email 推送邮箱 [ require false ]
     * @support  string $message 备注信息 [ require false ]
     * @support  string $delivery_area 收货省市区信息 [ require false ]
     * @support  string $delivery_address 收货详细地址信息 [ require false ]
     * @support  string $delivery_people 收货人 [ require false ]
     * @support  string $delivery_phone 收货手机 [ require false ]
     * @support  int $staff_id 工号 [ require false ]
     * @support  int $store_id 门店id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createInvoice ($context) {
        return self::getClass()->createInvoice([
            "context" => $context,
        ]);
    }

    /**
     * 重新开具发票(RPC调用)
     *
     * @support  int $invoice_id 要重开的发票id) [ require true ]
     * @support  string $invoice_belong 发票归属(himo|gift_card|product_card|other) [ require false ]
     * @support  string $title_type 抬头类型(person|company) [ require false ]
     * @support  bool $is_now 是否立即开具 [ require false ]
     * @support  string $name 购方名称 [ require true ]
     * @support  string $phone 购方手机 (开票成功会短信提醒购方) [ require false ]
     * @support  string $taxnum 购方税号(18/20位) [ require false ]
     * @support  array $order_nums 订单编号 [ require false ]
     * @support  array $detail 电子发票明细 [ require true ]
     * @support  string $telephone 购方电话 [ require false ]
     * @support  string $address 购方地址 [ require false ]
     * @support  string $account 购方银行账号(和开户行合在一起) [ require false ]
     * @support  string $email 推送邮箱 [ require false ]
     * @support  string $message 备注信息 [ require false ]
     * @support  string $delivery_area 收货省市区信息 [ require false ]
     * @support  string $delivery_address 收货详细地址信息 [ require false ]
     * @support  string $delivery_people 收货人 [ require false ]
     * @support  string $delivery_phone 收货手机 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reopen ($context) {
        return self::getClass()->reopen([
            "context" => $context,
        ]);
    }

    /**
     * 电子发票详情
     *
     * @support  int $id 电子发票id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail ($context) {
        return self::getClass()->detail([
            "context" => $context,
        ]);
    }

    /**
     * 电子发票详情(直接返回前端需要的数据格式)
     *
     * @support  int $id 电子发票id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detailRefit ($context) {
        return self::getClass()->detailRefit([
            "context" => $context,
        ]);
    }

    /**
     * 电子发票删除
     *
     * @support  int $id 电子发票id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete ($context) {
        return self::getClass()->delete([
            "context" => $context,
        ]);
    }

    /**
     * 设置开票完成状态
     *
     * @support  bool $is_electronic 是否是电子发票 [ require true ]
     * @support  int $id 发票ID [ require true ]
     * @support  string $delivery_company 快递公司(纸质发票传递,必传) [ require false ]
     * @support  int $delivery_id 快递单号(纸质发票传递,必传) [ require false ]
     * @support  bool $pass 是否通过(电子发票传递,必传) [ require false ]
     * @support  array $complete_extend 完成拓展字段 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function complete ($context) {
        return self::getClass()->complete([
            "context" => $context,
        ]);
    }

    /**
     * 电子发票列表
     *
     * @support  bool $is_electronic 是否是电子发票 [ require true ]
     * @support  string $order_no 订单号 [ require false ]
     * @support  string $invoke_type 发票类型 [ require false ]
     * @support  string $service_type 服务类型 [ require false ]
     * @support  string $start_time 开始时间 [ require false ]
     * @support  string $end_time 结束时间 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $title 抬头 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list ($context) {
        return self::getClass()->list([
            "context" => $context,
        ]);
    }

    /**
     * 每分钟检查下重开表中未重开成功的是否有冲红成功的，冲红成功后进行重开
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronSubmitFinalCommit () {
        return self::getClass()->cronSubmitFinalCommit();
    }

    /**
     * 发票作废(电子票会开红票)
     *
     * @param  int $invoice_id 发票ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function invalid (int $invoice_id) {
        return self::getClass()->invalid([
            "invoice_id" => $invoice_id,
        ]);
    }

    /**
     * 发票审核不通过
     *
     * @param  int $invoice_id 发票ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reviewFailed (int $invoice_id) {
        return self::getClass()->reviewFailed([
            "invoice_id" => $invoice_id,
        ]);
    }

    /**
     * 电子发票重新发送
     *
     * @param  int $invoice_id 发票id [ require true ]
     * @param  string $phone 手机号 [ require false ]
     * @param  string $email 邮箱 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function resend (int $invoice_id, string $phone = '', string $email = '') {
        return self::getClass()->resend([
            "invoice_id" => $invoice_id,
            "phone" => $phone,
            "email" => $email,
        ]);
    }

    /**
     * 可开发票订单列表
     *
     * @support  string $phone 手机号 [ require false ]
     * @support  string $order_no 订单号 [ require false ]
     * @support  bool $invoiced 是否已开票 [ require false ]
     * @support  int $store_id 门店id [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $page_size 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function invoiceList ($context) {
        return self::getClass()->invoiceList([
            "context" => $context,
        ]);
    }

    /**
     * 开票主体门店
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function invoiceSubject () {
        return self::getClass()->invoiceSubject();
    }

    /**
     * 各类订单可开发票订单列表
     *
     * @support  string $phone 手机号 [ require false ]
     * @support  string $order_no 订单号 [ require false ]
     * @support  string $type 订单类型 [ require true ]
     * @support  int $store_id 门店id [ require false ]
     * @support  bool $invoiced 是否已开票 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $page_size 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function canInvoiceList ($context) {
        return self::getClass()->canInvoiceList([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Invoice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Invoice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}