<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method infoByParams(array $params)
 * @method offlineByParams(array $params)
 * @method listByParams(array $params)
 */
class MemberActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 活动创建
     *
     * @support  string $title 活动标题 [ require true ]
     * @support  string $type 活动类型 [ require false ]
     * @support  int $sort 排序 [ require true ]
     * @support  int $points 积分值 [ require true ]
     * @support  array $extend 扩展 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create ($context) {
        return self::getClass()->create([
            "context" => $context,
        ]);
    }

    /**
     * 活动更新
     *
     * @support  int $id 活动ID [ require true ]
     * @support  string $title 活动标题 [ require false ]
     * @support  int $sort 活动排序 [ require false ]
     * @support  int $points 积分值 [ require false ]
     * @support  array $extend 扩展信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update ($context) {
        return self::getClass()->update([
            "context" => $context,
        ]);
    }

    /**
     * 活动详情
     *
     * @support  int $id 活动ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function info ($context) {
        return self::getClass()->info([
            "context" => $context,
        ]);
    }

    /**
     * 活动下线
     *
     * @support  int $id 活动ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offline ($context) {
        return self::getClass()->offline([
            "context" => $context,
        ]);
    }

    /**
     * 活动查询
     *
     * @support  array $types 活动类型, banner banner图, user_related 用户相关 [ require false ]
     * @support  string $title 活动标题 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list ($context) {
        return self::getClass()->list([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\MemberActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\MemberActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}