<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method createOrderByParams(array $params)
 * @method ownListByParams(array $params)
 * @method infoByParams(array $params)
 * @method createWechatCardByParams(array $params)
 * @method getCardByWechatCardByParams(array $params)
 * @method bindFromWechatByParams(array $params)
 * @method bindBackByParams(array $params)
 * @method coverListByParams(array $params)
 * @method topicListByParams(array $params)
 * @method previewByParams(array $params)
 * @method setCoverByParams(array $params)
 * @method balanceByParams(array $params)
 * @method chargeByParams(array $params)
 * @method bindByParams(array $params)
 * @method orderListByParams(array $params)
 * @method orderDetailByParams(array $params)
 * @method transactionListByParams(array $params)
 * @method chargeRecordByParams(array $params)
 * @method giveByParams(array $params)
 * @method giveDetailByParams(array $params)
 * @method receiveGiveByParams(array $params)
 * @method cancelGiveByParams(array $params)
 * @method confirmGiveByParams(array $params)
 * @method decodeOrderNumCodeByParams(array $params)
 */
class GiftCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 礼品卡列表
     *
     * @support  int $page 分页 [ require false ]
     * @support  int $page_size 每页数据量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list ($context) {
        return self::getClass()->list([
            "context" => $context,
        ]);
    }

    /**
     * 用户购买礼品卡
     *
     * @support  float $pay_money 实付 [ require true ]
     * @support  array $card_item 卡片信息 [ require true ]
     * @support  array $extend 额外信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrder ($context) {
        return self::getClass()->createOrder([
            "context" => $context,
        ]);
    }

    /**
     * 获取用户礼品卡列表
     *
     * @support  string $type 列表类型 [ require false ]
     * @support  string $sort_field 排序字段 [ require false ]
     * @support  string $sort_direction 排序方向,desc/asc [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function ownList ($context) {
        return self::getClass()->ownList([
            "context" => $context,
        ]);
    }

    /**
     * 获取用户礼品卡信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function info ($context) {
        return self::getClass()->info();
    }

    /**
     * 获取礼品卡微信卡券
     *
     * @support  string $code 礼品卡code [ require true ]
     * @support  string $open_id 微信标识 [ require true ]
     * @support  string $scene 场景 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createWechatCard ($context) {
        return self::getClass()->createWechatCard([
            "context" => $context,
        ]);
    }

    /**
     * 通过微信卡券返回码获取礼品卡信息
     *
     * @support  string $scene 场景 [ require true ]
     * @support  string $encrypt_code 微信加密的返回码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCardByWechatCard ($context) {
        return self::getClass()->getCardByWechatCard([
            "context" => $context,
        ]);
    }

    /**
     * 充值礼品卡并从微信卡包移除
     *
     * @support  string $code 礼品卡code [ require true ]
     * @support  string $scene 场景 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindFromWechat ($context) {
        return self::getClass()->bindFromWechat([
            "context" => $context,
        ]);
    }

    /**
     * 绑定礼品卡(用于领取到微信卡包失败)
     *
     * @support  string $code 礼品码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindBack ($context) {
        return self::getClass()->bindBack([
            "context" => $context,
        ]);
    }

    /**
     * 获取用户可用封面信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function coverList ($context) {
        return self::getClass()->coverList();
    }

    /**
     * 获取礼品卡类型信息
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function topicList ($context) {
        return self::getClass()->topicList([
            "context" => $context,
        ]);
    }

    /**
     * 获取预览信息
     *
     * @support  string $code 兑换码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function preview ($context) {
        return self::getClass()->preview([
            "context" => $context,
        ]);
    }

    /**
     * 设置cover
     *
     * @support  int $cover_id 礼品卡id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setCover ($context) {
        return self::getClass()->setCover([
            "context" => $context,
        ]);
    }

    /**
     * 获取用户余额
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function balance ($context) {
        return self::getClass()->balance();
    }

    /**
     * 充值礼品码
     *
     * @support  string $code 礼品码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function charge ($context) {
        return self::getClass()->charge([
            "context" => $context,
        ]);
    }

    /**
     * 绑定礼品码(微信卡券未领取后)
     *
     * @support  string $code 礼品码 [ require true ]
     * @support  string $scene 场景 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bind ($context) {
        return self::getClass()->bind([
            "context" => $context,
        ]);
    }

    /**
     * 获取礼品卡订单列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderList ($context) {
        return self::getClass()->orderList();
    }

    /**
     * 获取单个礼品卡订单详情
     *
     * @support  string $order_num 礼品卡订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderDetail ($context) {
        return self::getClass()->orderDetail([
            "context" => $context,
        ]);
    }

    /**
     * pay_for 订单 =&gt; order, 二销 =&gt; ds
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function transactionList ($context) {
        return self::getClass()->transactionList();
    }

    /**
     * 获取礼品卡充值记录
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function chargeRecord ($context) {
        return self::getClass()->chargeRecord();
    }

    /**
     * 发送邀请链接
     *
     * @support  int $gift_card_id 要送的礼品卡ID [ require true ]
     * @support  string $title 赠送标题 [ require true ]
     * @support  string $words 赠送语 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function give ($context) {
        return self::getClass()->give([
            "context" => $context,
        ]);
    }

    /**
     * 获取赠送详情
     *
     * @support  string $code 加密后的推送code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function giveDetail ($context) {
        return self::getClass()->giveDetail([
            "context" => $context,
        ]);
    }

    /**
     * 接受赠送
     *
     * @support  string $code 赠送code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveGive ($context) {
        return self::getClass()->receiveGive([
            "context" => $context,
        ]);
    }

    /**
     * 取消推送
     *
     * @support  int $card_id 赠送记录ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelGive ($context) {
        return self::getClass()->cancelGive([
            "context" => $context,
        ]);
    }

    /**
     * 确认推送
     *
     * @support  string $code 赠送记录code [ require true ]
     * @support  string $title 赠送标题 [ require true ]
     * @support  string $words 赠送语 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirmGive ($context) {
        return self::getClass()->confirmGive([
            "context" => $context,
        ]);
    }

    /**
     * 解密订单编码
     *
     * @support  string $code 加密后的推送code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function decodeOrderNumCode ($context) {
        return self::getClass()->decodeOrderNumCode([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\GiftCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\GiftCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}