<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Extend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method authorizeByParams(array $params)
 * @method authorizeCheckByParams(array $params)
 * @method isvConsumeByParams(array $params)
 * @method getMeituanStoreListByParams(array $params)
 * @method getBatchRemainCountByParams(array $params)
 * @method startBookByParams(array $params)
 * @method afterPayByParams(array $params)
 * @method bookResultCallbackByParams(array $params)
 * @method bookResultNotifyByParams(array $params)
 * @method cancelBookByParams(array $params)
 * @method consumeStatusByParams(array $params)
 * @method platformConsumeByParams(array $params)
 * @method consumeCodeByParams(array $params)
 * @method prepareByParams(array $params)
 * @method checkConsumedByParams(array $params)
 * @method createPaymentByParams(array $params)
 * @method paymentCallbackByParams(array $params)
 * @method getSessionForBigDataByParams(array $params)
 * @method ugcNotifyByParams(array $params)
 * @method flushCacheByParams(array $params)
 */
class DaZhongDianPing {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 授权
     *
     * @param  string $appKey 应用KEY [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function authorize (string $appKey) {
        return self::getClass()->authorize([
            "appKey" => $appKey,
        ]);
    }

    /**
     * 授权回调
     *
     * @param  string $state 状态码 [ require true ]
     * @param  string $auth_code 授权码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function authorizeCheck (string $state, string $auth_code) {
        return self::getClass()->authorizeCheck([
            "state" => $state,
            "auth_code" => $auth_code,
        ]);
    }

    /**
     * 到店核销
     *
     * @param  string $order_num 海马体订单号 [ require true ]
     * @param  int $store_id 海马体门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function isvConsume (string $order_num, int $store_id) {
        return self::getClass()->isvConsume([
            "order_num" => $order_num,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 获取已授权店铺列表
     *
     * @support  int $storeId 门店ID [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMeituanStoreList ($context) {
        return self::getClass()->getMeituanStoreList([
            "context" => $context,
        ]);
    }

    /**
     * 批量获取库存
     *
     * @support  string $app_key app_key [ require true ]
     * @support  string $timestamp 时间戳，Y-m-d H:i:s [ require true ]
     * @support  string $format 响应格式，json [ require true ]
     * @support  string $v api版本，1 [ require true ]
     * @support  string $sign_method 签名算法，md5 [ require true ]
     * @support  string $sign 签名 [ require true ]
     * @support  string $app_shop_id 海马体门店id [ require false ]
     * @support  string $open_shop_uuid 美团点评门店id [ require false ]
     * @support  string $bookdate 预定时间，Y-m-d [ require true ]
     * @support  string $durations 服务时长 [ require false ]
     * @support  string $days 几天的库存 [ require true ]
     * @support  string $inventory_product_info 项目信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBatchRemainCount ($context) {
        return self::getClass()->getBatchRemainCount([
            "context" => $context,
        ]);
    }

    /**
     * 预定
     *
     * @support  string $app_key app_key [ require true ]
     * @support  string $timestamp 时间戳，Y-m-d H:i:s [ require true ]
     * @support  string $format 响应格式，json [ require true ]
     * @support  string $v api版本，1 [ require true ]
     * @support  string $sign_method 签名算法，md5 [ require true ]
     * @support  string $sign 签名 [ require true ]
     * @support  string $app_shop_id 海马体门店id [ require false ]
     * @support  string $open_shop_uuid 美团点评门店id [ require false ]
     * @support  string $order_id 美团订单id [ require true ]
     * @support  string $app_product_id 海马体产品id [ require true ]
     * @support  int $product_id 美团产品id [ require false ]
     * @support  string $product_name 产品名称 [ require false ]
     * @support  string $begintime 服务开始时间，Y-m-d H:i:s [ require true ]
     * @support  int $duration 持续时长 [ require false ]
     * @support  string $endtime 服务结束时间，Y-m-d H:i:s [ require true ]
     * @support  string $products 预定商品信息 [ require false ]
     * @support  string $user_name 用户名 [ require false ]
     * @support  string $user_gender 性别 [ require false ]
     * @support  string $mobile 手机号 [ require true ]
     * @support  string $app_period_id 时段id [ require false ]
     * @support  int $user_age 用户年龄 [ require false ]
     * @support  string $identity_num 身份证 [ require false ]
     * @support  string $married 是否结婚1未婚2已婚 [ require false ]
     * @support  string $amount 订单原总价 [ require false ]
     * @support  string $order_shoppromo_details 订单优惠详情 [ require false ]
     * @support  int $quantity 预定数量 [ require true ]
     * @support  string $comment 备注 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function startBook ($context) {
        return self::getClass()->startBook([
            "context" => $context,
        ]);
    }

    /**
     * 支付完成后续流程
     *
     * @param  int $order_id 海马体订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function afterPay (int $order_id) {
        return self::getClass()->afterPay([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 回调通知大众点评下单结果
     *
     * @support  string $meituan_order_id 美团订单id [ require true ]
     * @support  string $store_id 美团门店id [ require true ]
     * @support  string $order_num 订单号 [ require true ]
     * @support  int $status 下单结果 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bookResultCallback ($context) {
        return self::getClass()->bookResultCallback([
            "context" => $context,
        ]);
    }

    /**
     * 大众点评预定处理结果同步海马体
     *
     * @support  string $app_key app_key [ require true ]
     * @support  string $timestamp 时间戳，Y-m-d H:i:s [ require true ]
     * @support  string $format 响应格式，json [ require true ]
     * @support  string $v api版本，1 [ require true ]
     * @support  string $sign_method 签名算法，md5 [ require true ]
     * @support  string $app_shop_id 海马体门店id [ require false ]
     * @support  string $open_shop_uuid 美团点评门店id [ require false ]
     * @support  string $order_id 美团订单id [ require true ]
     * @support  string $app_product_id 海马体产品id [ require true ]
     * @support  int $product_id 美团产品id [ require false ]
     * @support  string $product_name 产品名称 [ require false ]
     * @support  int $book_channel 预定渠道1三方2美大 [ require true ]
     * @support  int $book_status 预定结果2成功3失败 [ require true ]
     * @support  string $begintime 服务开始时间，Y-m-d H:i [ require true ]
     * @support  int $duration 持续时长 [ require false ]
     * @support  string $endtime 服务结束时间，Y-m-d H:i [ require true ]
     * @support  string $products 预定商品信息 [ require false ]
     * @support  string $user_name 用户名 [ require false ]
     * @support  string $user_gender 性别 [ require false ]
     * @support  string $mobile 手机号 [ require true ]
     * @support  string $app_period_id 时段id [ require false ]
     * @support  int $user_age 用户年龄 [ require false ]
     * @support  string $identity_num 身份证 [ require false ]
     * @support  string $married 是否结婚1未婚2已婚 [ require false ]
     * @support  string $amount 订单原总价 [ require false ]
     * @support  string $order_shoppromo_details 订单优惠详情 [ require false ]
     * @support  int $quantity 预定数量 [ require true ]
     * @support  string $comment 备注 [ require false ]
     * @support  string $biz_type biz_type [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bookResultNotify ($context) {
        return self::getClass()->bookResultNotify([
            "context" => $context,
        ]);
    }

    /**
     * 取消预定
     *
     * @support  string $app_key app_key [ require true ]
     * @support  string $timestamp 时间戳，Y-m-d H:i:s [ require true ]
     * @support  string $format 响应格式，json [ require true ]
     * @support  string $v api版本，1 [ require true ]
     * @support  string $sign_method 签名算法，md5 [ require true ]
     * @support  string $sign 签名 [ require true ]
     * @support  string $app_shop_id 海马体门店id [ require false ]
     * @support  string $open_shop_uuid 美团点评门店id [ require false ]
     * @support  string $order_id 美团订单id [ require false ]
     * @support  int $cancel_type 取消类型 1=规则取消：用户正常规则下取消 2=非规则取消：除规则取消之外的其他取消，如用户通过开放平台客服强制取消 [ require true ]
     * @support  int $audit_channel 取消预定审核渠道1海马体2美团 [ require false ]
     * @support  string $reason 取消的原因 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelBook ($context) {
        return self::getClass()->cancelBook([
            "context" => $context,
        ]);
    }

    /**
     * 取消预定时的订单状态查询
     *
     * @support  string $app_key app_key [ require true ]
     * @support  string $timestamp 时间戳，Y-m-d H:i:s [ require true ]
     * @support  string $format 响应格式，json [ require true ]
     * @support  string $v api版本，1 [ require true ]
     * @support  string $sign_method 签名算法，md5 [ require true ]
     * @support  string $sign 签名 [ require true ]
     * @support  string $order_id 美团订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function consumeStatus ($context) {
        return self::getClass()->consumeStatus([
            "context" => $context,
        ]);
    }

    /**
     * 核销状态同步
     *
     * @support  string $app_key app_key [ require true ]
     * @support  string $timestamp 时间戳，Y-m-d H:i:s [ require false ]
     * @support  string $format 响应格式，json [ require true ]
     * @support  string $v api版本，1 [ require true ]
     * @support  string $sign_method 签名算法，md5 [ require true ]
     * @support  string $sign 签名 [ require true ]
     * @support  string $order_id 美团订单id [ require true ]
     * @support  int $verify_status 核销状态2核销成功 [ require true ]
     * @support  int $verify_channel 核销渠道 1=第三方平台核销 2=新美大平台核销 [ require true ]
     * @support  string $app_shop_id 海马体门店id [ require false ]
     * @support  string $open_shop_uuid 美团门店id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function platformConsume ($context) {
        return self::getClass()->platformConsume([
            "context" => $context,
        ]);
    }

    /**
     * 核销美团大众券
     *
     * @param  string $receipt_code 美团大众点评团购券 [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function consumeCode (string $receipt_code, int $storeId) {
        return self::getClass()->consumeCode([
            "receipt_code" => $receipt_code,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 校验美团大众券信息
     *
     * @param  string $receipt_code 美团大众点评团购券 [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function prepare (string $receipt_code, int $storeId) {
        return self::getClass()->prepare([
            "receipt_code" => $receipt_code,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 检查是否已核销
     *
     * @param  string $receipt_code 美团大众点评团购券 [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkConsumed (string $receipt_code, int $storeId) {
        return self::getClass()->checkConsumed([
            "receipt_code" => $receipt_code,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 创建美团大众点评支付单
     *
     * @support  string $order_num 订单号或子订单号 [ require true ]
     * @support  float $pay_money 金额 [ require true ]
     * @support  int $operator_id 操作人 [ require false ]
     * @support  string $receipt_code 核销码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPayment ($context) {
        return self::getClass()->createPayment([
            "context" => $context,
        ]);
    }

    /**
     * 支付回调
     *
     * @support  string $data 交易返回数据 [ require true ]
     * @support  string $sign 支付签名 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function paymentCallback ($context) {
        return self::getClass()->paymentCallback([
            "context" => $context,
        ]);
    }

    /**
     * 获取点评session
     *
     * @support  string $appKey 应用KEY [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSessionForBigData ($context) {
        return self::getClass()->getSessionForBigData([
            "context" => $context,
        ]);
    }

    /**
     * 查询并发送大众点评中差评价数据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function ugcNotify () {
        return self::getClass()->ugcNotify();
    }

    /**
     * 清除点评核销码缓存
     *
     * @param  string $receiptCode code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function flushCache (string $receiptCode) {
        return self::getClass()->flushCache([
            "receiptCode" => $receiptCode,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Extend\DaZhongDianPing');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Extend\DaZhongDianPing');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}