<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method qrcodeByParams(array $params)
 */
class Channel {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增渠道
     *
     * @param  string $name 渠道名称 [ require true ]
     * @param  string $brand 品牌(himo,himo_gold,show_pic_wx) [ require true ]
     * @param  int $channel_num 渠道号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function add (string $name, int $channel_num, string $brand = 'himo') {
        return self::getClass()->add([
            "name" => $name,
            "channel_num" => $channel_num,
            "brand" => $brand,
        ]);
    }

    /**
     * 更新渠道信息
     *
     * @param  int $id 渠道id [ require true ]
     * @param  string $name 渠道名称 [ require true ]
     * @param  string $brand 品牌(himo,himo_gold,show_pic_wx) [ require true ]
     * @param  int $channel_num 渠道号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, int $channel_num = 0, string $name = '', string $brand = '') {
        return self::getClass()->update([
            "id" => $id,
            "channel_num" => $channel_num,
            "name" => $name,
            "brand" => $brand,
        ]);
    }

    /**
     * 渠道号列表
     *
     * @support  string $name 渠道名称 require false
     * @support  int $channelNum 渠道号 require false
     * @support  string $brand 品牌(himo,himo_gold,show_pic_wx) require false
     * @support  int $page 页码 require false
     * @support  int $page_size 每页条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 删除渠道
     *
     * @param  int $id 渠道id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 获取渠道二维码
     *
     * @param  int $id 渠道id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function qrcode (int $id) {
        return self::getClass()->qrcode([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Channel');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Channel');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}