<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method feedbackByParams(array $params)
 * @method vipQcsCodeByParams(array $params)
 * @method receiveQcsCodeByParams(array $params)
 * @method sendPhotoUpdatePushByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户意见反馈
     *
     * @support  string $content 内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function feedback ($context) {
        return self::getClass()->feedback([
            "context" => $context,
        ]);
    }

    /**
     * 获取屈臣氏code
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function vipQcsCode ($context) {
        return self::getClass()->vipQcsCode();
    }

    /**
     * 领取屈臣氏code
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveQcsCode ($context) {
        return self::getClass()->receiveQcsCode();
    }

    /**
     * 发送图片更新推送
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendPhotoUpdatePush (int $userId, string $orderNo) {
        return self::getClass()->sendPhotoUpdatePush([
            "userId" => $userId,
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}