<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method exportByParams(array $params)
 * @method cityByParams(array $params)
 * @method allByParams(array $params)
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method managersByParams(array $params)
 * @method updateByParams(array $params)
 * @method noReleaseByParams(array $params)
 * @method releaseByParams(array $params)
 * @method getDepartmentListByParams(array $params)
 * @method hookStoreUsePosStatusByParams(array $params)
 * @method getNotOpenStoreAllByParams(array $params)
 * @method batchSetAllNotOpenStoreByParams(array $params)
 * @method getCityIdsByPriceAreaIdsByParams(array $params)
 * @method getGroupsByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店列表
     *
     * @support  string $name 店名 require false
     * @support  int $group_id 集团ID require false
     * @support  string $affiliate_type 加盟类型 require false
     * @support  int $province_id 省份ID require false
     * @support  int $city_id 城市ID require false
     * @support  int $area_id 运营区域ID require false
     * @support  int $city_type_id 城市类型ID require false
     * @support  string $store_type 品牌 require false
     * @support  string $status 门店状态 require false
     * @support  int $page 页数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 门店列表信息导出
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function export () {
        return self::getClass()->export();
    }

    /**
     * 获取有门店的所有城市
     *
     * @support  array $store_type 门店类型集合 require false
     * @support  bool $includeDelete 是否包含未开业门店 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function city () {
        return self::getClass()->city();
    }

    /**
     * 根据分组获取门店(不传参数则为全部)
     *
     * @support  string $classification 分组维度(填写该参数后sc_id无效) require false
     * @support  int $sc_id 分组id require false
     * @support  bool $include_delete 是否包含删除 require false
     * @support  string $store_type 门店类型 require false
     * @support  bool $only_mantu 只显示缦图摄影门店 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 创建门店
     *
     * @support  string $name 店名 [ require true ]
     * @support  int $city_id 城市ID [ require true ]
     * @support  int $city_type_id 城市类型ID require false
     * @support  int $sc_id 区域分组id [ require true ]
     * @support  int $province_id 省ID [ require true ]
     * @support  int $group_id 所属集团ID require false
     * @support  int $dept_id 部门id [ require true ]
     * @support  string $store_type 门店类型(blue(蓝标)|gold(金标)|kids(儿童)) require false
     * @support  string $affiliate_type 加盟类型(direct(直营)|join(加盟)) [ require true ]
     * @support  string $start_appointment_time 开始预约时间 format: H:i:s [ require true ]
     * @support  string $stop_appointment_time 结束预约时间 format: H:i:s [ require true ]
     * @support  mixed $extend 附带的信息 [ require true ]
     * @support  int $service_interval 服务间隔(分钟) [ require true ]
     * @support  int $service_times 每间隔同时服务数 [ require true ]
     * @support  string $start_business 开始营业时间 format: Y-m-d H:i:s [ require true ]
     * @support  int $sort 门店排序 [ require true ]
     * @support  string $dianping_id 点评门店id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取门店信息
     *
     * @param  int $id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 获取所有区域经理
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function managers () {
        return self::getClass()->managers();
    }

    /**
     * 修改门店信息
     *
     * @support  string $name 店名 [ require true ]
     * @support  int $city_id 城市ID [ require true ]
     * @support  int $sc_id 区域分组id [ require true ]
     * @support  int $province_id 省ID [ require true ]
     * @support  int $group_id 所属集团ID require false
     * @support  int $id 门店编号 [ require true ]
     * @support  string $affiliate_type 加盟类型(direct(直营)|join(加盟)) [ require true ]
     * @support  string $start_appointment_time 开始预约时间 format: h:i:s [ require true ]
     * @support  string $stop_appointment_time 结束预约时间 format: h:i:s [ require true ]
     * @support  int $service_times 门店每时段服务数 require false
     * @support  mixed $extend 附带的信息 [ require true ]
     * @support  int $sort 门店排序 [ require true ]
     * @support  string $use_pos_status pos机启用状态 require false
     * @support  string $dianping_id 美团门店id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 门店下线
     *
     * @support  int $id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function noRelease () {
        return self::getClass()->noRelease();
    }

    /**
     * 门店上线
     *
     * @support  int $id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function release () {
        return self::getClass()->release();
    }

    /**
     * 获取部门列表
     *
     * @support  string $type 部门类型(headquarter,himo_store,kid_store,photography_store) [ require true ]
     * @support  bool $no_bind_store 是否获取未绑定的门店 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDepartmentList () {
        return self::getClass()->getDepartmentList();
    }

    /**
     * 门店pos绑定事件
     *
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookStoreUsePosStatus (int $storeId) {
        return self::getClass()->hookStoreUsePosStatus([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取所有未营业门店
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNotOpenStoreAll () {
        return self::getClass()->getNotOpenStoreAll();
    }

    /**
     * 批量设置所有未营业门店
     *
     * @param  array $storeIds 门店ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchSetAllNotOpenStore (array $storeIds = []) {
        return self::getClass()->batchSetAllNotOpenStore([
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 根据价格区获取城市ids
     *
     * @param  string $price_area_ids 价格区ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCityIdsByPriceAreaIds (string $price_area_ids = '') {
        return self::getClass()->getCityIdsByPriceAreaIds([
            "price_area_ids" => $price_area_ids,
        ]);
    }

    /**
     * 集团列表
     *
     * @support  int $page 页码 require false
     * @support  int $page_size 数量 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroups () {
        return self::getClass()->getGroups();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}