<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method articleListByParams(array $params)
 * @method deleteArticleByParams(array $params)
 */
class HappyArticleShare {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 幸福照相馆 - 分享文章列表
     *
     * @support  string $createAtStart 提交开始时间 [ require false ]
     * @support  string $createAtEnd 提交结束时间 [ require false ]
     * @support  string $phone 账号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function articleList ($context) {
        return self::getClass()->articleList([
            "context" => $context,
        ]);
    }

    /**
     * 幸福照相馆 - 删除分享文章
     *
     * @support  int $articleId 文章ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteArticle ($context) {
        return self::getClass()->deleteArticle([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\HappyArticleShare');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\HappyArticleShare');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}