<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method countByParams(array $params)
 * @method countPageByParams(array $params)
 * @method listsByParams(array $params)
 * @method exportListByParams(array $params)
 * @method refundByParams(array $params)
 * @method bindOrderByParams(array $params)
 * @method closeOrderByParams(array $params)
 */
class CheckBill {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 汇总数据
     *
     * @support  int $storeId 门店id [ require false ]
     * @support  string $tradeAtStart 交易日期始 [ require false ]
     * @support  string $tradeAtEnd 交易日期末 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function count ($context) {
        return self::getClass()->count([
            "context" => $context,
        ]);
    }

    /**
     * 汇总数据-分页
     *
     * @support  int $storeId 门店id [ require false ]
     * @support  string $tradeAtStart 交易日期始 [ require false ]
     * @support  string $tradeAtEnd 交易日期末 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function countPage ($context) {
        return self::getClass()->countPage([
            "context" => $context,
        ]);
    }

    /**
     * 详细列表
     *
     * @support  string $status 订单状态 [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @support  string $orderNo 订单号 [ require false ]
     * @support  string $source 订单来源 [ require false ]
     * @support  string $payType 支付方式 [ require false ]
     * @support  string $tradeAtStart 交易日期始 [ require true ]
     * @support  string $tradeAtEnd 交易日期末 [ require true ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function lists ($context) {
        return self::getClass()->lists([
            "context" => $context,
        ]);
    }

    /**
     * 导出明细
     *
     * @support  string $status 订单状态 [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @support  string $source 订单来源 [ require false ]
     * @support  string $payType 支付方式 [ require false ]
     * @support  string $orderNo 订单号 [ require false ]
     * @support  string $tradeAtStart 交易日期始 [ require true ]
     * @support  string $tradeAtEnd 交易日期末 [ require true ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exportList ($context) {
        return self::getClass()->exportList([
            "context" => $context,
        ]);
    }

    /**
     * 拉卡拉单边-退款
     *
     * @support  int $recordId 记录ID [ require true ]
     * @support  string $paymentNo 网关订单号 [ require true ]
     * @support  float $money 退款金额 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refund ($context) {
        return self::getClass()->refund([
            "context" => $context,
        ]);
    }

    /**
     * 拉卡拉单边-绑定订单
     *
     * @support  int $recordId 记录ID [ require true ]
     * @support  string $orderNo 订单号 [ require true ]
     * @support  string $source 订单来源 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindOrder ($context) {
        return self::getClass()->bindOrder([
            "context" => $context,
        ]);
    }

    /**
     * 订单单边-关闭订单
     *
     * @support  int $recordId 记录ID [ require true ]
     * @support  string $orderNo 订单号 [ require true ]
     * @support  string $reason 关闭原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrder ($context) {
        return self::getClass()->closeOrder([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\CheckBill');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\CheckBill');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}