<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method sortTagsByParams(array $params)
 * @method getTagsByParams(array $params)
 */
class Tag {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品标签
     *
     * @param  string $key 英文标签名称 [ require true ]
     * @param  string $label 中文标签名称 [ require true ]
     * @param  int $seq 标签顺序 [ require false ]
     * @param  string $creator 创建人 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create ($context, string $key, string $label, int $seq = 0, string $creator = '') {
        return self::getClass()->create([
            "context" => $context,
            "key" => $key,
            "label" => $label,
            "seq" => $seq,
            "creator" => $creator,
        ]);
    }

    /**
     * 产品标签排序
     *
     * @support  array $keys 需要排序的复杂数组 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sortTags ($context) {
        return self::getClass()->sortTags([
            "context" => $context,
        ]);
    }

    /**
     * 获取标签
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTags () {
        return self::getClass()->getTags();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Retail\Tag');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Retail\Tag');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}