<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 */
class StoreInsurance {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 门店保险创建
     *
     * @support  int $store_id 门店ID [ require true ]
     * @support  array $liability_insurance 责任险 [ require false ]
     * @support  array $property_insurance 财产险 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create ($context) {
        return self::getClass()->create([
            "context" => $context,
        ]);
    }

    /**
     * 门店保险更新
     *
     * @support  string $_id 保险ID [ require true ]
     * @support  array $liability_insurance 责任险 [ require false ]
     * @support  array $property_insurance 财产险 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update ($context) {
        return self::getClass()->update([
            "context" => $context,
        ]);
    }

    /**
     * 查询
     *
     * @param  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $store_id) {
        return self::getClass()->detail([
            "store_id" => $store_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\StoreInsurance');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\StoreInsurance');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}