<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addChartLetByParams(array $params)
 * @method chartLetListByParams(array $params)
 * @method updateChartLetByParams(array $params)
 * @method changeStatusByParams(array $params)
 * @method deletedByParams(array $params)
 * @method infoByParams(array $params)
 * @method tagSelectByParams(array $params)
 */
class ChartLet {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加贴图
     *
     * @support  array $materials 素材信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addChartLet ($context) {
        return self::getClass()->addChartLet([
            "context" => $context,
        ]);
    }

    /**
     * 贴图素材列表
     *
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 分页数 [ require false ]
     * @support  string $brand 品牌 [ require false ]
     * @support  int $productId 产品id [ require false ]
     * @support  string $status 状态:on,off [ require false ]
     * @support  string $materialType 素材类别 [ require false ]
     * @support  string $range 素材类别 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function chartLetList ($context) {
        return self::getClass()->chartLetList([
            "context" => $context,
        ]);
    }

    /**
     * 编辑贴图
     *
     * @support  int $id 贴图id [ require true ]
     * @support  string $name 贴图名称 [ require false ]
     * @support  string $brand 品牌 [ require false ]
     * @support  int $productId 产品id [ require false ]
     * @support  string $materialType 素材类别 [ require false ]
     * @support  array $tags 标签ids [ require false ]
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $weight 权重 [ require false ]
     * @support  string $materialPath 图像地址 [ require false ]
     * @support  string $materialSamplePath 样片地址 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateChartLet ($context) {
        return self::getClass()->updateChartLet([
            "context" => $context,
        ]);
    }

    /**
     * 更改素材状态
     *
     * @support  int $materialId 贴图id [ require true ]
     * @support  string $status 启用状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStatus ($context) {
        return self::getClass()->changeStatus([
            "context" => $context,
        ]);
    }

    /**
     * 删除贴图素材
     *
     * @support  int $materialId 贴图id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleted ($context) {
        return self::getClass()->deleted([
            "context" => $context,
        ]);
    }

    /**
     * 素材详情
     *
     * @support  int $materialId 贴图id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function info ($context) {
        return self::getClass()->info([
            "context" => $context,
        ]);
    }

    /**
     * 标签下拉
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function tagSelect ($context) {
        return self::getClass()->tagSelect();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ChartLet');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ChartLet');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}