<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 */
class GiftCardSeries {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建礼品卡系列
     *
     * @param  string $title 标题 [ require true ]
     * @param  int $sequence 排序值 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $title, int $sequence = 0) {
        return self::getClass()->create([
            "title" => $title,
            "sequence" => $sequence,
        ]);
    }

    /**
     * 更新礼品卡系列
     *
     * @support  int $id id [ require true ]
     * @support  string $title 标题 require false
     * @support  int $sequence 排序值 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 获取礼品卡系列信息
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 获取礼品卡系列列表(分页)
     *
     * @support  string $title 标题 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 每页条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取礼品卡系列列表(全部)
     *
     * @support  string $title 标题 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\GiftCardSeries');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\GiftCardSeries');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}