<?php
namespace Mainto\Bridge\Invokes\HimoProduct\SupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method getShipInfoByParams(array $params)
 * @method getShipProductListByParams(array $params)
 * @method allShipProductsByParams(array $params)
 * @method updateExpressByParams(array $params)
 * @method getAllSkuByParams(array $params)
 * @method setShipProductFinishedByParams(array $params)
 * @method cancelShipProductFinishedByParams(array $params)
 * @method storeShipProductListByParams(array $params)
 */
class RetailShipment {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加发货单
     *
     * @support  int $staffId 工号 [ require false ]
     * @support  string $reason 原因 [ require false ]
     * @support  array $shipProducts 发货信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create ($context) {
        return self::getClass()->create([
            "context" => $context,
        ]);
    }

    /**
     * 删除发货单
     *
     * @param  int $id 记录store_ship_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove ($context, int $id) {
        return self::getClass()->remove([
            "context" => $context,
            "id" => $id,
        ]);
    }

    /**
     * 发货单列表
     *
     * @support  string $createTimeStart 开始时间 [ require false ]
     * @support  string $createTimeEnd 结束时间 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list ($context) {
        return self::getClass()->list([
            "context" => $context,
        ]);
    }

    /**
     * 获取发货单基本信息(不包含发货单的商品)
     *
     * @param  int $id 发货id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getShipInfo (int $id) {
        return self::getClass()->getShipInfo([
            "id" => $id,
        ]);
    }

    /**
     * 获取发货单的发货商品列表
     *
     * @support  int $id 发货id [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @support  string $productName 产品名 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  bool $showDeleted 是否包含删除数据 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getShipProductList ($context) {
        return self::getClass()->getShipProductList([
            "context" => $context,
        ]);
    }

    /**
     * 获取发货单的所有商品(导出时调用该接口)
     *
     * @support  int $id 发货单id [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @support  string $productName 产品名 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  bool $showDeleted 是否包含删除数据 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function allShipProducts ($context) {
        return self::getClass()->allShipProducts([
            "context" => $context,
        ]);
    }

    /**
     * 设置发货商品的快递单号信息
     *
     * @support  int $id 记录id [ require false ]
     * @support  int $operateId 操作人id [ require false ]
     * @support  array $expressInfo 快递单号信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateExpress ($context) {
        return self::getClass()->updateExpress([
            "context" => $context,
        ]);
    }

    /**
     * 获取所有零售sku(添加发货明细中的导出零售产品的功能)
     *
     * @support  bool $withOffSku 是否包含下架的sku [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllSku ($context) {
        return self::getClass()->getAllSku([
            "context" => $context,
        ]);
    }

    /**
     * 设置发货商品完成收货
     *
     * @param  int $id 发货商品id [ require true ]
     * @param  int $storeShipId 发货单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setShipProductFinished ($context, int $id, int $storeShipId) {
        return self::getClass()->setShipProductFinished([
            "context" => $context,
            "id" => $id,
            "storeShipId" => $storeShipId,
        ]);
    }

    /**
     * 撤回发货商品已完成状态
     *
     * @param  int $id 发货商品id [ require true ]
     * @param  int $storeShipId 发货单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelShipProductFinished ($context, int $id, int $storeShipId) {
        return self::getClass()->cancelShipProductFinished([
            "context" => $context,
            "id" => $id,
            "storeShipId" => $storeShipId,
        ]);
    }

    /**
     * 根据门店id获取收货列表
     *
     * @support  int $storeId 门店id [ require false ]
     * @support  string $createTimeStart 发货单开始时间 [ require false ]
     * @support  string $createTimeEnd 发货单结束时间 [ require false ]
     * @support  string $express 快递单号 [ require false ]
     * @support  string $skuCode sku编码 [ require false ]
     * @support  string $productName 商品名称 [ require false ]
     * @support  array $statusList 状态 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function storeShipProductList ($context) {
        return self::getClass()->storeShipProductList([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'SupplyChain\RetailShipment');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'SupplyChain\RetailShipment');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}