<?php
namespace Mainto\Bridge\Invokes\HimoProduct\SupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method submitByParams(array $params)
 * @method batchSubmitByParams(array $params)
 * @method resubmitByParams(array $params)
 * @method deleteNewByParams(array $params)
 * @method batchCreateByParams(array $params)
 * @method getStoresForPurchaseByParams(array $params)
 * @method sendPurchaseMsgByParams(array $params)
 */
class PurchaseGroup {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建集采
     *
     * @param  string $storeType 门店类型 [ require true ]
     * @param  string $remark 下单原因 [ require true ]
     * @param  array $storeIds 门店id数组 [ require true ]
     * @param  array $skuInfo 物料sku数组 [ require true ]
     * @param  string $purchaseType 采购类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create ($context, string $storeType, string $remark, array $storeIds, array $skuInfo, string $purchaseType = 'group') {
        return self::getClass()->create([
            "context" => $context,
            "storeType" => $storeType,
            "remark" => $remark,
            "storeIds" => $storeIds,
            "skuInfo" => $skuInfo,
            "purchaseType" => $purchaseType,
        ]);
    }

    /**
     * 修改集采
     *
     * @param  int $id id [ require true ]
     * @support  string $storeType 门店类型 [ require false ]
     * @support  string $remark 下单原因 [ require false ]
     * @param  array $storeInfo 门店修改信息 [ require true ]
     * @param  array $skuInfo 物料sku数组 [ require true ]
     * @param  string $purchaseType 采购类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update ($context, int $id, array $storeInfo, array $skuInfo, string $purchaseType = 'group') {
        return self::getClass()->update([
            "context" => $context,
            "id" => $id,
            "storeInfo" => $storeInfo,
            "skuInfo" => $skuInfo,
            "purchaseType" => $purchaseType,
        ]);
    }

    /**
     * 集采列表[分页]
     *
     * @support  string $startAt start_at [ require false ]
     * @support  string $endAt end_at [ require false ]
     * @support  int $createBy 下单人工号 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $type 集采类型:normal/excel [ require false ]
     * @support  string $purchaseType 采购类型 [ require false ]
     * @param  int $page page [ require false ]
     * @param  int $pageSize pageSize [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list ($context, int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "context" => $context,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 集采详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 集采提交
     *
     * @param  int $id 集采申请id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function submit (int $id) {
        return self::getClass()->submit([
            "id" => $id,
        ]);
    }

    /**
     * 集采批量提交
     *
     * @param  array $ids 集采申请ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchSubmit (array $ids) {
        return self::getClass()->batchSubmit([
            "ids" => $ids,
        ]);
    }

    /**
     * 集采重新提交
     *
     * @param  int $id 采购申请单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function resubmit (int $id) {
        return self::getClass()->resubmit([
            "id" => $id,
        ]);
    }

    /**
     * 删除新建状态的集采
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteNew (int $id) {
        return self::getClass()->deleteNew([
            "id" => $id,
        ]);
    }

    /**
     * 批量集采
     *
     * @param  array $purchaseInfo 采购信息 [ require true ]
     * @param  string $remark 采购备注 [ require true ]
     * @param  string $purchaseType 采购类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchCreate ($context, array $purchaseInfo, string $remark, string $purchaseType) {
        return self::getClass()->batchCreate([
            "context" => $context,
            "purchaseInfo" => $purchaseInfo,
            "remark" => $remark,
            "purchaseType" => $purchaseType,
        ]);
    }

    /**
     * getStoresForPurchase
     *
     * @support  string $storeType 门店类型 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoresForPurchase ($context) {
        return self::getClass()->getStoresForPurchase([
            "context" => $context,
        ]);
    }

    /**
     * sendPurchaseMsg
     *
     * @param  int $groupId 采购单id [ require true ]
     * @param  array $purchaseIds 采购单id [ require true ]
     * @param  bool $result 结果 [ require true ]
     * @throws  \Exception
     * @return  void
     */
    public static function sendPurchaseMsg (int $groupId, array $purchaseIds, bool $result) {
        return self::getClass()->sendPurchaseMsg([
            "groupId" => $groupId,
            "purchaseIds" => $purchaseIds,
            "result" => $result,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'SupplyChain\PurchaseGroup');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'SupplyChain\PurchaseGroup');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}