<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method uploadByParams(array $params)
 * @method getUploadInfoByParams(array $params)
 * @method listByParams(array $params)
 * @method updateUpdatedAtByIdsByParams(array $params)
 * @method openNextBatchByParams(array $params)
 * @method auditByParams(array $params)
 * @method areaSelectByParams(array $params)
 * @method getStaffRoleAuthByParams(array $params)
 * @method messageRemindingByParams(array $params)
 * @method overdueRemoveByParams(array $params)
 */
class UnreviewedGuestPhotos {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 授权通过，加入客片审核中
     *
     * @support  int $store_id 店铺id [ require true ]
     * @support  int $order_id 订单id [ require true ]
     * @support  array $images 图片数据[[&#039;photo_id&#039;=&gt;1,&#039;product_id&#039;=&gt;123,&#039;photo_url&#039;=&gt;&#039;123.jgp&#039;],[&#039;photo_id&#039;=&gt;2,&#039;product_id&#039;=&gt;123,&#039;photo_url&#039;=&gt;&#039;123.jgp&#039;]] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function upload ($context) {
        return self::getClass()->upload([
            "context" => $context,
        ]);
    }

    /**
     * 返回已经上传的客片信息
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUploadInfo ($context) {
        return self::getClass()->getUploadInfo([
            "context" => $context,
        ]);
    }

    /**
     * 获取客片审核列表
     *
     * @support  array $product_ids 产品ids [ require false ]
     * @support  int $area_id 区域id [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list ($context) {
        return self::getClass()->list([
            "context" => $context,
        ]);
    }

    /**
     * 更新客片更新时间
     *
     * @support  array $ids 客片ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateUpdatedAtByIds ($context) {
        return self::getClass()->updateUpdatedAtByIds([
            "context" => $context,
        ]);
    }

    /**
     * 开启下一批审核
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function openNextBatch ($context) {
        return self::getClass()->openNextBatch();
    }

    /**
     * 客片批量审核
     *
     * @support  array $ids 客片ids [ require true ]
     * @support  array $tags 标签ids [ require false ]
     * @support  string $result 结果[pass, not_pass] [ require true ]
     * @support  bool $is_photography_action 是否加入摄影动作(true 加入，false不加入) [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function audit ($context) {
        return self::getClass()->audit([
            "context" => $context,
        ]);
    }

    /**
     * 客片审核区域下拉数据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function areaSelect ($context) {
        return self::getClass()->areaSelect();
    }

    /**
     * 得到当前用户角色权限
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffRoleAuth ($context) {
        return self::getClass()->getStaffRoleAuth();
    }

    /**
     * 每天10点执行
     * 需要完成的任务：
     * 1. 检查督导的钉钉提醒
     * 2. 专家的钉钉提醒
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function messageReminding () {
        return self::getClass()->messageReminding();
    }

    /**
     * 逾期移除,每天0点0分1秒执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function overdueRemove () {
        return self::getClass()->overdueRemove();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\UnreviewedGuestPhotos');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\UnreviewedGuestPhotos');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}