<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method extractByParams(array $params)
 * @method getProgressByParams(array $params)
 * @method getAllProductByBrandByParams(array $params)
 * @method getTodayEvaluateCountByParams(array $params)
 * @method getExtractListByParams(array $params)
 * @method notDealWithTheItemByParams(array $params)
 * @method changeItemByParams(array $params)
 * @method preCommitScoreByParams(array $params)
 * @method getPreScoreListByParams(array $params)
 * @method confirmByParams(array $params)
 * @method preCheckUpdateConfigByParams(array $params)
 * @method lockUpdateConfigByParams(array $params)
 * @method unlockUpdateConfigByParams(array $params)
 * @method getScoreConfigByParams(array $params)
 * @method updateScoreConfigByParams(array $params)
 * @method queryRecordHistoryByParams(array $params)
 * @method queryQualityReportByParams(array $params)
 * @method queryHistoryAggregateByParams(array $params)
 * @method getStoreIdsByStaffByParams(array $params)
 * @method getStaffByParams(array $params)
 * @method getStreamInfoByParams(array $params)
 * @method cronSubmitFinalCommitByParams(array $params)
 * @method delScoreByParams(array $params)
 * @method getPhotoProblemTagSetsByParams(array $params)
 */
class CheckPool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 抽片
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @support  int $newStaffCount 新人伙伴抽样量 [ require false ]
     * @support  int $formalStaffCount 正式伙伴抽样量 [ require false ]
     * @support  array $productArr 产品类型组 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function extract ($context, string $poolType) {
        return self::getClass()->extract([
            "context" => $context,
            "poolType" => $poolType,
        ]);
    }

    /**
     * 获取抽片进度
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProgress ($context, string $poolType) {
        return self::getClass()->getProgress([
            "context" => $context,
            "poolType" => $poolType,
        ]);
    }

    /**
     * 通过品牌获取所有产品
     *
     * @param  string $brand 品牌 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllProductByBrand (string $brand = '') {
        return self::getClass()->getAllProductByBrand([
            "brand" => $brand,
        ]);
    }

    /**
     * 今日已评单量
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTodayEvaluateCount ($context, string $poolType) {
        return self::getClass()->getTodayEvaluateCount([
            "context" => $context,
            "poolType" => $poolType,
        ]);
    }

    /**
     * 获取抽片列表
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getExtractList ($context, string $poolType) {
        return self::getClass()->getExtractList([
            "context" => $context,
            "poolType" => $poolType,
        ]);
    }

    /**
     * 不处理此项
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @param  string $itemId 项目id [ require true ]
     * @param  int $staffId 不处理的伙伴id [ require true ]
     * @param  bool $todayNotExtract 当天不抽取该伙伴 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function notDealWithTheItem ($context, string $poolType, string $itemId, int $staffId, bool $todayNotExtract = true) {
        return self::getClass()->notDealWithTheItem([
            "context" => $context,
            "poolType" => $poolType,
            "itemId" => $itemId,
            "staffId" => $staffId,
            "todayNotExtract" => $todayNotExtract,
        ]);
    }

    /**
     * 换一单
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @param  string $itemId 项目id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeItem ($context, string $poolType, string $itemId) {
        return self::getClass()->changeItem([
            "context" => $context,
            "poolType" => $poolType,
            "itemId" => $itemId,
        ]);
    }

    /**
     * 预评分
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @param  string $itemId 项目id [ require true ]
     * @param  array $score 评分内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function preCommitScore ($context, string $poolType, string $itemId, array $score) {
        return self::getClass()->preCommitScore([
            "context" => $context,
            "poolType" => $poolType,
            "itemId" => $itemId,
            "score" => $score,
        ]);
    }

    /**
     * 获取预评分列表
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPreScoreList ($context, string $poolType) {
        return self::getClass()->getPreScoreList([
            "context" => $context,
            "poolType" => $poolType,
        ]);
    }

    /**
     * 最终确认
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @support  array $batchScore 批量评分 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirm ($context, string $poolType) {
        return self::getClass()->confirm([
            "context" => $context,
            "poolType" => $poolType,
        ]);
    }

    /**
     * 预检查是否可以更新配置
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function preCheckUpdateConfig (string $poolType) {
        return self::getClass()->preCheckUpdateConfig([
            "poolType" => $poolType,
        ]);
    }

    /**
     * 锁配置
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function lockUpdateConfig (string $poolType) {
        return self::getClass()->lockUpdateConfig([
            "poolType" => $poolType,
        ]);
    }

    /**
     * 解锁配置
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unlockUpdateConfig (string $poolType) {
        return self::getClass()->unlockUpdateConfig([
            "poolType" => $poolType,
        ]);
    }

    /**
     * 获取评分配置
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @param  bool $withDel 是否包含删除项 [ require false ]
     * @param  bool $filterZero 是否去除包含0分的配置项 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getScoreConfig (string $poolType, bool $withDel = false, bool $filterZero = true) {
        return self::getClass()->getScoreConfig([
            "poolType" => $poolType,
            "withDel" => $withDel,
            "filterZero" => $filterZero,
        ]);
    }

    /**
     * 评分配置调整
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @param  array $delConfig 删除配置 [ require false ]
     * @param  array $newConfig 新增配置 [ require false ]
     * @param  array $updateConfig 更新配置 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateScoreConfig ($context, string $poolType, array $delConfig = [], array $newConfig = [], array $updateConfig = []) {
        return self::getClass()->updateScoreConfig([
            "context" => $context,
            "poolType" => $poolType,
            "delConfig" => $delConfig,
            "newConfig" => $newConfig,
            "updateConfig" => $updateConfig,
        ]);
    }

    /**
     * 查询评分历史记录
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @param  string $startTime 评分开始时间 [ require true ]
     * @param  string $endTime 评分结束时间 [ require true ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryRecordHistory ($context, string $poolType, string $startTime, string $endTime, int $page = 1, int $pageSize = 10) {
        return self::getClass()->queryRecordHistory([
            "context" => $context,
            "poolType" => $poolType,
            "startTime" => $startTime,
            "endTime" => $endTime,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 查询质量报告
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @support  string $startTime 评分开始时间 [ require true ]
     * @support  string $endTime 评分结束时间 [ require true ]
     * @support  array $storeIds 门店ids [ require false ]
     * @support  array $productIds 产品ids [ require false ]
     * @support  array $problemTagsIds 问题标签ids [ require false ]
     * @support  array $supervisorArr 督导ids [ require false ]
     * @support  array $staffIds 伙伴ids [ require false ]
     * @support  array $score 评分内容 [ require false ]
     * @support  array $totalScoreRange 总分区间 [ require false ]
     * @support  string $order_num 拍摄订单号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryQualityReport ($context, string $poolType) {
        return self::getClass()->queryQualityReport([
            "context" => $context,
            "poolType" => $poolType,
        ]);
    }

    /**
     * 查询聚合数据
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @support  string $startTime 评分开始时间 [ require false ]
     * @support  string $endTime 评分结束时间 [ require false ]
     * @support  array $storeIds 门店ids [ require false ]
     * @support  array $productIds 产品ids [ require false ]
     * @support  array $problemTagsIds 问题标签ids [ require false ]
     * @support  array $supervisorArr 督导ids [ require false ]
     * @support  array $staffIds 伙伴ids [ require false ]
     * @support  array $score 评分内容 [ require false ]
     * @support  array $totalScoreRange 总分区间 [ require false ]
     * @support  string $order_num 拍摄订单号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryHistoryAggregate ($context, string $poolType) {
        return self::getClass()->queryHistoryAggregate([
            "context" => $context,
            "poolType" => $poolType,
        ]);
    }

    /**
     * 通过伙伴获取有权限的门店信息
     *
     * @param  array $staffIds 伙伴ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreIdsByStaff (array $staffIds) {
        return self::getClass()->getStoreIdsByStaff([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 获取伙伴(根据入职时间)
     *
     * @param  string $staffEntryType 伙伴入职类型 [ require false ]
     * @param  array $storeIds 门店ids [ require false ]
     * @param  string $nameOrNickname 姓名或昵称(模糊匹配) [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaff ($context, string $staffEntryType = '', array $storeIds = [], string $nameOrNickname = '') {
        return self::getClass()->getStaff([
            "context" => $context,
            "staffEntryType" => $staffEntryType,
            "storeIds" => $storeIds,
            "nameOrNickname" => $nameOrNickname,
        ]);
    }

    /**
     * 获取流水信息
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @param  int $cloudStreamId 流水id [ require true ]
     * @param  string $startTime 评分开始时间 [ require true ]
     * @param  string $endTime 评分结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStreamInfo (string $poolType, int $cloudStreamId, string $startTime, string $endTime) {
        return self::getClass()->getStreamInfo([
            "poolType" => $poolType,
            "cloudStreamId" => $cloudStreamId,
            "startTime" => $startTime,
            "endTime" => $endTime,
        ]);
    }

    /**
     * 定时任务提交最终评分
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronSubmitFinalCommit () {
        return self::getClass()->cronSubmitFinalCommit();
    }

    /**
     * 删除评分
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @param  int $cloudStreamId 流水id [ require true ]
     * @param  string $startTime 评分开始时间 [ require true ]
     * @param  string $endTime 评分结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delScore ($context, string $poolType, int $cloudStreamId, string $startTime, string $endTime) {
        return self::getClass()->delScore([
            "context" => $context,
            "poolType" => $poolType,
            "cloudStreamId" => $cloudStreamId,
            "startTime" => $startTime,
            "endTime" => $endTime,
        ]);
    }

    /**
     * 获取摄影化妆问题标签
     *
     * @param  string $about photography/makeup [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhotoProblemTagSets ($context, string $about = null) {
        return self::getClass()->getPhotoProblemTagSets([
            "context" => $context,
            "about" => $about,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\CheckPool');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\CheckPool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}