<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hotProductMaterialListByParams(array $params)
 * @method hotProductMaterialAddByParams(array|MakeAnAppointmentConfig\HotProductMaterialAdd\HotProductMaterialDto $params)
 * @method hotProductMaterialDeleteByParams(array $params)
 * @method hotProductRecommendListByParams(array $params)
 * @method hotProductRecommendUpdateByParams(array|MakeAnAppointmentConfig\HotProductRecommendUpdate\HotProductRecommendDto $params)
 * @method hotInformationListByParams(array $params)
 * @method hotInformationAddByParams(array|MakeAnAppointmentConfig\HotInformationAdd\HotInformationDto $params)
 * @method hotInformationEditByParams(array|MakeAnAppointmentConfig\HotInformationEdit\HotInformationUpdateDto $params)
 * @method hotInformationDelByParams(array $params)
 * @method hotInformationDetailByParams(array $params)
 * @method hotInformationUpdateStatusByParams(array $params)
 * @method addArticleCategoryByParams(array $params)
 * @method deleteArticleCategoryByParams(array $params)
 * @method editArticleCategoryByParams(array $params)
 * @method getArticleCategoryByParams(array $params)
 * @method listArticleCategoryByParams(array $params)
 * @method getChannelCategoryMaxByParams(array $params)
 * @method getResourceBitConfigurationsListByParams(array $params)
 * @method resourceBitConfigurationsAddByParams(array|MakeAnAppointmentConfig\ResourceBitConfigurationsAdd\ResourceBitConfigurationsDto $params)
 * @method resourceBitConfigurationsEditByParams(array|MakeAnAppointmentConfig\ResourceBitConfigurationsEdit\ResourceBitConfigurationsUpdateDto $params)
 * @method getResourceBitConfigurationsDetailByParams(array $params)
 * @method resourceBitConfigurationsEditStatusByParams(array $params)
 * @method resourceBitConfigurationsDelByParams(array $params)
 * @method getFollowingPageListByParams(array $params)
 * @method followingPageGiftCardAddByParams(array|MakeAnAppointmentConfig\FollowingPageGiftCardAdd\FollowingPageGiftCardDto $params)
 * @method followingPageGiftCardDeleteByParams(array $params)
 * @method followingPageGiftCardDetailByParams(array $params)
 * @method followingPageGiftCardEditByParams(array|MakeAnAppointmentConfig\FollowingPageGiftCardEdit\FollowingPageGiftCardUpdateDto $params)
 * @method followingPageAddTypeByParams(array $params)
 * @method followingPageDeleteTypeByParams(array $params)
 * @method followingPageEditTypeByParams(array $params)
 * @method followingPageAddProductDetailByParams(array|MakeAnAppointmentConfig\FollowingPageAddProductDetail\FollowingPageProductDetailDto $params)
 * @method followingPageEditProductDetailByParams(array|MakeAnAppointmentConfig\FollowingPageEditProductDetail\FollowingPageProductDetailUpdateDto $params)
 * @method followingPageDeleteProductDetailByParams(array $params)
 * @method getFollowingPageMaxSortByParams(array $params)
 * @method getFollowingPageTypeListByParams(array $params)
 */
class MakeAnAppointmentConfig {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 热门产品推荐-素材库列表
     *
     * @support  string $template_id 模板id require false
     * @support  int $page page require false
     * @support  int $page_size page_size require false
     * @throws  \Exception
     * @return  array[]
     */
    public static function hotProductMaterialList () {
        return self::getClass()->hotProductMaterialList();
    }

    /**
     * 热门产品推荐-素材库添加
     *
     * @var  MakeAnAppointmentConfig\HotProductMaterialAdd\HotProductMaterialDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function hotProductMaterialAdd (MakeAnAppointmentConfig\HotProductMaterialAdd\HotProductMaterialDto $dto) {
        return self::getClass()->hotProductMaterialAdd($dto);
    }


    /**
     * 热门产品推荐-素材库删除
     *
     * @support  string $hot_product_material_id 热门产品素材库id require false
     * @throws  \Exception
     * @return  bool
     */
    public static function hotProductMaterialDelete () {
        return self::getClass()->hotProductMaterialDelete();
    }

    /**
     * 热门产品推荐-推荐列表
     *
     * @throws  \Exception
     * @return  array[]
     */
    public static function hotProductRecommendList () {
        return self::getClass()->hotProductRecommendList();
    }

    /**
     * 热门产品推荐-推荐更新
     *
     * @var  MakeAnAppointmentConfig\HotProductRecommendUpdate\HotProductRecommendDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function hotProductRecommendUpdate (MakeAnAppointmentConfig\HotProductRecommendUpdate\HotProductRecommendDto $dto) {
        return self::getClass()->hotProductRecommendUpdate($dto);
    }


    /**
     * 热门资讯-列表
     *
     * @support  string $channel in:himo,himo_alipay,himo_app,family require false
     * @support  string $node_type in:article,link require false
     * @support  string $status in:online,offline require false
     * @support  int $page page require false
     * @support  int $page_size pageSize require false
     * @throws  \Exception
     * @return  array[]
     */
    public static function hotInformationList () {
        return self::getClass()->hotInformationList();
    }

    /**
     * 热门资讯-添加
     *
     * @var  MakeAnAppointmentConfig\HotInformationAdd\HotInformationDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function hotInformationAdd (MakeAnAppointmentConfig\HotInformationAdd\HotInformationDto $dto) {
        return self::getClass()->hotInformationAdd($dto);
    }


    /**
     * 热门资讯-修改
     *
     * @var  MakeAnAppointmentConfig\HotInformationEdit\HotInformationUpdateDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function hotInformationEdit (MakeAnAppointmentConfig\HotInformationEdit\HotInformationUpdateDto $dto) {
        return self::getClass()->hotInformationEdit($dto);
    }


    /**
     * 热门资讯-删除
     *
     * @support  int $hot_information_id 热门资讯id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hotInformationDel () {
        return self::getClass()->hotInformationDel();
    }

    /**
     * 热门资讯-详情
     *
     * @support  int $hot_information_id 热门资讯id [ require true ]
     * @throws  \Exception
     * @return  array[]
     */
    public static function hotInformationDetail () {
        return self::getClass()->hotInformationDetail();
    }

    /**
     * 热门资讯-更新状态
     *
     * @support  int $hot_information_id 热门资讯id [ require true ]
     * @support  string $status 状态值,in:online,offline [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hotInformationUpdateStatus () {
        return self::getClass()->hotInformationUpdateStatus();
    }

    /**
     * 热门资讯-文章类目新增
     *
     * @support  string $channel 所属渠道 [ require true ]
     * @support  string $name 名称 [ require true ]
     * @support  int $sort 排序 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function addArticleCategory () {
        return self::getClass()->addArticleCategory();
    }

    /**
     * 热门资讯-文章类目删除
     *
     * @support  int $articleCategoryId 文章类目id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteArticleCategory () {
        return self::getClass()->deleteArticleCategory();
    }

    /**
     * 热门资讯-文章类目编辑
     *
     * @support  int $articleCategoryId 文章类目id [ require true ]
     * @support  string $channel 所属渠道 [ require true ]
     * @support  string $name 名称 [ require true ]
     * @support  int $sort 排序 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editArticleCategory () {
        return self::getClass()->editArticleCategory();
    }

    /**
     * 热门资讯-文章类目详情
     *
     * @support  int $articleCategoryId 文章类目id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getArticleCategory () {
        return self::getClass()->getArticleCategory();
    }

    /**
     * 热门资讯-文章类目列表
     *
     * @support  string $channel 所属渠道 require false
     * @support  int $page page require false
     * @support  int $pageSize pageSize require false
     * @throws  \Exception
     * @return  array
     */
    public static function listArticleCategory () {
        return self::getClass()->listArticleCategory();
    }

    /**
     * 热门资讯-获取指定渠道类目的最大数量
     *
     * @support  string $channel 所属渠道 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getChannelCategoryMax () {
        return self::getClass()->getChannelCategoryMax();
    }

    /**
     * 资源位配置-列表
     *
     * @support  string $channel 所属渠道 require false
     * @support  string $status 状态 require false
     * @support  int $page page require false
     * @support  int $page_size page_size require false
     * @throws  \Exception
     * @return  array
     */
    public static function getResourceBitConfigurationsList () {
        return self::getClass()->getResourceBitConfigurationsList();
    }

    /**
     * 资源位配置-添加
     *
     * @var  MakeAnAppointmentConfig\ResourceBitConfigurationsAdd\ResourceBitConfigurationsDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function resourceBitConfigurationsAdd (MakeAnAppointmentConfig\ResourceBitConfigurationsAdd\ResourceBitConfigurationsDto $dto) {
        return self::getClass()->resourceBitConfigurationsAdd($dto);
    }


    /**
     * 资源位配置-修改
     *
     * @var  MakeAnAppointmentConfig\ResourceBitConfigurationsEdit\ResourceBitConfigurationsUpdateDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function resourceBitConfigurationsEdit (MakeAnAppointmentConfig\ResourceBitConfigurationsEdit\ResourceBitConfigurationsUpdateDto $dto) {
        return self::getClass()->resourceBitConfigurationsEdit($dto);
    }


    /**
     * 资源位配置-得到详情
     *
     * @support  string $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getResourceBitConfigurationsDetail () {
        return self::getClass()->getResourceBitConfigurationsDetail();
    }

    /**
     * 资源位配置-修改状态
     *
     * @support  string $id id [ require true ]
     * @support  string $status 状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function resourceBitConfigurationsEditStatus () {
        return self::getClass()->resourceBitConfigurationsEditStatus();
    }

    /**
     * 资源位配置-删除
     *
     * @support  string $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function resourceBitConfigurationsDel () {
        return self::getClass()->resourceBitConfigurationsDel();
    }

    /**
     * 承接页-列表
     *
     * @support  string $brand 品牌 [ require true ]
     * @support  string $channel 渠道 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getFollowingPageList () {
        return self::getClass()->getFollowingPageList();
    }

    /**
     * 承接页-添加礼品卡
     *
     * @var  MakeAnAppointmentConfig\FollowingPageGiftCardAdd\FollowingPageGiftCardDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function followingPageGiftCardAdd (MakeAnAppointmentConfig\FollowingPageGiftCardAdd\FollowingPageGiftCardDto $dto) {
        return self::getClass()->followingPageGiftCardAdd($dto);
    }


    /**
     * 承接页-删除礼品卡
     *
     * @support  string $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function followingPageGiftCardDelete () {
        return self::getClass()->followingPageGiftCardDelete();
    }

    /**
     * 承接页-得到详情
     *
     * @support  string $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function followingPageGiftCardDetail () {
        return self::getClass()->followingPageGiftCardDetail();
    }

    /**
     * 承接页-编辑礼品卡
     *
     * @var  MakeAnAppointmentConfig\FollowingPageGiftCardEdit\FollowingPageGiftCardUpdateDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function followingPageGiftCardEdit (MakeAnAppointmentConfig\FollowingPageGiftCardEdit\FollowingPageGiftCardUpdateDto $dto) {
        return self::getClass()->followingPageGiftCardEdit($dto);
    }


    /**
     * 承接页-添加分类
     *
     * @support  string $name name [ require true ]
     * @support  string $brand 品牌 [ require true ]
     * @support  int $sort 排序 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function followingPageAddType () {
        return self::getClass()->followingPageAddType();
    }

    /**
     * 承接页-删除分类
     *
     * @support  string $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function followingPageDeleteType () {
        return self::getClass()->followingPageDeleteType();
    }

    /**
     * 承接页-编辑分类
     *
     * @support  string $name name [ require true ]
     * @support  string $id id [ require true ]
     * @support  int $sort 排序 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function followingPageEditType () {
        return self::getClass()->followingPageEditType();
    }

    /**
     * 承接页-添加产品详情数据
     *
     * @var  MakeAnAppointmentConfig\FollowingPageAddProductDetail\FollowingPageProductDetailDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function followingPageAddProductDetail (MakeAnAppointmentConfig\FollowingPageAddProductDetail\FollowingPageProductDetailDto $dto) {
        return self::getClass()->followingPageAddProductDetail($dto);
    }


    /**
     * 承接页-编辑产品详情数据
     *
     * @var  MakeAnAppointmentConfig\FollowingPageEditProductDetail\FollowingPageProductDetailUpdateDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function followingPageEditProductDetail (MakeAnAppointmentConfig\FollowingPageEditProductDetail\FollowingPageProductDetailUpdateDto $dto) {
        return self::getClass()->followingPageEditProductDetail($dto);
    }


    /**
     * 承接页-删除产品详情数据
     *
     * @support  string $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function followingPageDeleteProductDetail () {
        return self::getClass()->followingPageDeleteProductDetail();
    }

    /**
     * 承接页-得到MaxSort排序值
     *
     * @support  string $brand brand [ require true ]
     * @support  string $type type require false
     * @throws  \Exception
     * @return  int
     */
    public static function getFollowingPageMaxSort () {
        return self::getClass()->getFollowingPageMaxSort();
    }

    /**
     * 承接页-得到类型列表
     *
     * @support  string $brand brand [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getFollowingPageTypeList () {
        return self::getClass()->getFollowingPageTypeList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\MakeAnAppointmentConfig');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\MakeAnAppointmentConfig');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}