<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hotProductMaterialListByParams(array $params)
 * @method hotProductMaterialAddByParams(array|MakeAnAppointmentConfig\HotProductMaterialAdd\HotProductMaterialDto $params)
 * @method hotProductMaterialDeleteByParams(array $params)
 * @method hotProductRecommendListByParams(array $params)
 * @method hotProductRecommendUpdateByParams(array|MakeAnAppointmentConfig\HotProductRecommendUpdate\HotProductRecommendDto $params)
 * @method hotInformationListByParams(array $params)
 * @method hotInformationAddByParams(array|MakeAnAppointmentConfig\HotInformationAdd\HotInformationDto $params)
 * @method hotInformationEditByParams(array|MakeAnAppointmentConfig\HotInformationEdit\HotInformationUpdateDto $params)
 * @method hotInformationDelByParams(array $params)
 * @method hotInformationDetailByParams(array $params)
 * @method hotInformationUpdateStatusByParams(array $params)
 * @method addArticleCategoryByParams(array $params)
 * @method deleteArticleCategoryByParams(array $params)
 * @method editArticleCategoryByParams(array $params)
 * @method getArticleCategoryByParams(array $params)
 * @method listArticleCategoryByParams(array $params)
 */
class MakeAnAppointmentConfig {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 热门产品推荐-素材库列表
     *
     * @support  string $template_id 模板id require false
     * @support  int $page page require false
     * @support  int $page_size page_size require false
     * @throws  \Exception
     * @return  array[]
     */
    public static function hotProductMaterialList () {
        return self::getClass()->hotProductMaterialList();
    }

    /**
     * 热门产品推荐-素材库添加
     *
     * @var  MakeAnAppointmentConfig\HotProductMaterialAdd\HotProductMaterialDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function hotProductMaterialAdd (MakeAnAppointmentConfig\HotProductMaterialAdd\HotProductMaterialDto $dto) {
        return self::getClass()->hotProductMaterialAdd($dto);
    }


    /**
     * 热门产品推荐-素材库删除
     *
     * @support  string $hot_product_material_id 热门产品素材库id require false
     * @throws  \Exception
     * @return  bool
     */
    public static function hotProductMaterialDelete () {
        return self::getClass()->hotProductMaterialDelete();
    }

    /**
     * 热门产品推荐-推荐列表
     *
     * @throws  \Exception
     * @return  array[]
     */
    public static function hotProductRecommendList () {
        return self::getClass()->hotProductRecommendList();
    }

    /**
     * 热门产品推荐-推荐更新
     *
     * @var  MakeAnAppointmentConfig\HotProductRecommendUpdate\HotProductRecommendDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function hotProductRecommendUpdate (MakeAnAppointmentConfig\HotProductRecommendUpdate\HotProductRecommendDto $dto) {
        return self::getClass()->hotProductRecommendUpdate($dto);
    }


    /**
     * 热门资讯-列表
     *
     * @support  string $channel in:himo,himo_alipay,himo_app,family require false
     * @support  string $node_type in:article,link require false
     * @support  string $status in:online,offline require false
     * @support  int $page page require false
     * @support  int $page_size pageSize require false
     * @throws  \Exception
     * @return  array[]
     */
    public static function hotInformationList () {
        return self::getClass()->hotInformationList();
    }

    /**
     * 热门资讯-添加
     *
     * @var  MakeAnAppointmentConfig\HotInformationAdd\HotInformationDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function hotInformationAdd (MakeAnAppointmentConfig\HotInformationAdd\HotInformationDto $dto) {
        return self::getClass()->hotInformationAdd($dto);
    }


    /**
     * 热门资讯-修改
     *
     * @var  MakeAnAppointmentConfig\HotInformationEdit\HotInformationUpdateDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function hotInformationEdit (MakeAnAppointmentConfig\HotInformationEdit\HotInformationUpdateDto $dto) {
        return self::getClass()->hotInformationEdit($dto);
    }


    /**
     * 热门资讯-删除
     *
     * @support  int $hot_information_id 热门资讯id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hotInformationDel () {
        return self::getClass()->hotInformationDel();
    }

    /**
     * 热门资讯-详情
     *
     * @support  int $hot_information_id 热门资讯id [ require true ]
     * @throws  \Exception
     * @return  array[]
     */
    public static function hotInformationDetail () {
        return self::getClass()->hotInformationDetail();
    }

    /**
     * 热门资讯-更新状态
     *
     * @support  int $hot_information_id 热门资讯id [ require true ]
     * @support  string $status 状态值,in:online,offline [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hotInformationUpdateStatus () {
        return self::getClass()->hotInformationUpdateStatus();
    }

    /**
     * 热门资讯-文章类目新增
     *
     * @support  string $channel 所属渠道 [ require true ]
     * @support  string $name 名称 [ require true ]
     * @support  int $sort 排序 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function addArticleCategory () {
        return self::getClass()->addArticleCategory();
    }

    /**
     * 热门资讯-文章类目删除
     *
     * @support  int $articleCategoryId 文章类目id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteArticleCategory () {
        return self::getClass()->deleteArticleCategory();
    }

    /**
     * 热门资讯-文章类目编辑
     *
     * @support  int $articleCategoryId 文章类目id [ require true ]
     * @support  string $channel 所属渠道 [ require true ]
     * @support  string $name 名称 [ require true ]
     * @support  int $sort 排序 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editArticleCategory () {
        return self::getClass()->editArticleCategory();
    }

    /**
     * 热门资讯-文章类目详情
     *
     * @support  int $articleCategoryId 文章类目id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getArticleCategory () {
        return self::getClass()->getArticleCategory();
    }

    /**
     * 热门资讯-文章类目列表
     *
     * @support  string $channel 所属渠道 require false
     * @support  int $page page require false
     * @support  int $pageSize pageSize require false
     * @throws  \Exception
     * @return  array
     */
    public static function listArticleCategory () {
        return self::getClass()->listArticleCategory();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\MakeAnAppointmentConfig');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\MakeAnAppointmentConfig');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}