<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addProductDiscountRuleByParams(array $params)
 * @method getProductDiscountListByParams(array $params)
 * @method getProductDiscountByIdsByParams(array $params)
 * @method productDiscountDetailByParams(array $params)
 * @method deleteDiscountByParams(array $params)
 * @method getStoreDiscountByParams(array $params)
 */
class ProductDiscount {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新建通用计算折扣规则
     *
     * @support  string $name 折扣名称 [ require true ]
     * @support  int $sort 折扣顺序, 折扣时将从最大的开始匹配 require false
     * @support  int $sc_id 门店分类ID, 用于筛选门店 [ require true ]
     * @support  string $discount_type 折扣类型 [ require true ]
     * @support  string $share_type 共享类型 [ require true ]
     * @support  string $payload_check 折扣规则校验 [ require true ]
     * @support  array $payload_arr 折扣适用产品 require false
     * @support  int $mini_kind_num 最小产品种类 require false
     * @support  int $mini_pay_num 最小产品数量 require false
     * @support  float $mini_buy_price 最小购买金额 require false
     * @support  string $payload_type 折扣适配类型 require false
     * @support  bool $pick 是否打包优惠 [ require true ]
     * @support  float $discount_value 折扣计算值 require false
     * @support  float $start_discount_value 起始折扣值 require false
     * @support  bool $is_limit 是否为限时折扣 require false
     * @support  string $start_time 折扣开始时间 require false
     * @support  string $end_time 折扣结束时间 require false
     * @support  string $group 分组（是否可与优惠券共用） [ require true ]
     * @support  array $show_info 前端显示信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function addProductDiscountRule () {
        return self::getClass()->addProductDiscountRule();
    }

    /**
     * 折扣列表
     *
     * @support  int $page 当前页 require false
     * @support  int $page_size 页内条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductDiscountList () {
        return self::getClass()->getProductDiscountList();
    }

    /**
     * 折扣列表
     *
     * @support  string $ids ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductDiscountByIds () {
        return self::getClass()->getProductDiscountByIds();
    }

    /**
     * 获取折扣信息
     *
     * @support  int $id 编辑的ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productDiscountDetail () {
        return self::getClass()->productDiscountDetail();
    }

    /**
     * 删除折扣
     *
     * @support  int $discount_id 折扣id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteDiscount () {
        return self::getClass()->deleteDiscount();
    }

    /**
     * 获取的折扣可能包含一个小时内将会开始, 但是当前暂未开始的活动, 需要前端注意判断
     *
     * @support  int $store_id 门店ID require false
     * @support  bool $add_hour 是否包含一个小时内将会开始的活动 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreDiscount () {
        return self::getClass()->getStoreDiscount();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductDiscount');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductDiscount');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}