<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 */
class Rentals {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 门店租金缴费录入
     *
     * @support  int $store_id 门店编号 [ require true ]
     * @support  string $attachment 附件 require false
     * @support  string $contract_start_at 合同开始日期 require false
     * @support  string $contract_end_at 合同结束日期 require false
     * @support  int $apply_time 最晚申请时间 [ require true ]
     * @support  array $fixed_rent 固定租金 require false
     * @support  array $property 物业费 require false
     * @support  array $promotion 推广费 require false
     * @support  array $trash_cleanup 垃圾清理费 require false
     * @support  array $pos_rent POS租金 require false
     * @support  array $more 其他费用 require false
     * @support  array $extend 扩展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 门店租金缴费更新
     *
     * @support  string $id 合同id require false
     * @support  int $store_id 门店编号 require false
     * @support  string $contract_start_at 合同开始日期 require false
     * @support  string $contract_end_at 合同结束日期 require false
     * @support  int $apply_time 最晚申请时间 require false
     * @support  array $fixed_rent 固定租金 require false
     * @support  array $property 物业费 require false
     * @support  array $promotion 推广费 require false
     * @support  array $more 其他费用 require false
     * @support  array $extend 扩展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 查询
     *
     * @param  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $store_id) {
        return self::getClass()->detail([
            "store_id" => $store_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Rentals');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Rentals');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}