<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPackageByParams(array $params)
 * @method listPackagesByParams(array $params)
 * @method getSubPackageByParams(array $params)
 */
class Package {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取套餐详情
     *
     * @support  int $packageId 套餐id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPackage () {
        return self::getClass()->getPackage();
    }

    /**
     * 获取门店套餐详情
     *
     * @support  int $storeId 门店id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function listPackages () {
        return self::getClass()->listPackages();
    }

    /**
     * 获取子套餐详情
     *
     * @support  int $packageId 套餐id [ require true ]
     * @support  int $subPackageId 子套餐id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSubPackage () {
        return self::getClass()->getSubPackage();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Package');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Package');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}