<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hotProductMaterialListByParams(array $params)
 * @method hotProductMaterialAddByParams(array|MakeAnAppointmentConfig\HotProductMaterialAdd\HotProductMaterialDto $params)
 * @method hotProductMaterialDeleteByParams(array $params)
 * @method hotProductRecommendListByParams(array $params)
 * @method hotProductRecommendUpdateByParams(array|MakeAnAppointmentConfig\HotProductRecommendUpdate\HotProductRecommendDto $params)
 * @method hotInformationListByParams(array $params)
 */
class MakeAnAppointmentConfig {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 热门产品推荐-素材库列表
     *
     * @support  string $template_id 模板id require false
     * @throws  \Exception
     * @return  array[]
     */
    public static function hotProductMaterialList () {
        return self::getClass()->hotProductMaterialList();
    }

    /**
     * 热门产品推荐-素材库添加
     *
     * @var  MakeAnAppointmentConfig\HotProductMaterialAdd\HotProductMaterialDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function hotProductMaterialAdd (MakeAnAppointmentConfig\HotProductMaterialAdd\HotProductMaterialDto $dto) {
        return self::getClass()->hotProductMaterialAdd($dto);
    }


    /**
     * 热门产品推荐-素材库删除
     *
     * @support  string $material_id 热门产品素材库id require false
     * @throws  \Exception
     * @return  bool
     */
    public static function hotProductMaterialDelete () {
        return self::getClass()->hotProductMaterialDelete();
    }

    /**
     * 热门产品推荐-推荐列表
     *
     * @throws  \Exception
     * @return  array[]
     */
    public static function hotProductRecommendList () {
        return self::getClass()->hotProductRecommendList();
    }

    /**
     * 热门产品推荐-推荐更新
     *
     * @var  MakeAnAppointmentConfig\HotProductRecommendUpdate\HotProductRecommendDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function hotProductRecommendUpdate (MakeAnAppointmentConfig\HotProductRecommendUpdate\HotProductRecommendDto $dto) {
        return self::getClass()->hotProductRecommendUpdate($dto);
    }


    /**
     * 热门资讯-列表
     *
     * @support  string $channel in:himo,himo_alipay,himo_app,family require false
     * @support  string $node_type in:article,link require false
     * @support  string $status in:online,offline require false
     * @support  int $page page require false
     * @support  int $pageSize pageSize require false
     * @throws  \Exception
     * @return  array[]
     */
    public static function hotInformationList () {
        return self::getClass()->hotInformationList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\MakeAnAppointmentConfig');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\MakeAnAppointmentConfig');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}