<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method photoDetailByParams(array $params)
 * @method operationPhotoByParams(array $params)
 * @method saveGuestPhotoByParams(array $params)
 * @method saveGuestPhotoByUploadByParams(array $params)
 * @method bmsHookStreamProblemTagPhotographyByParams(array $params)
 * @method bmsHookStreamProblemTagMakeupByParams(array $params)
 * @method getPhotoListByParams(array $params)
 * @method getSimilarByImgByParams(array $params)
 * @method getOrderDetailByImgByParams(array $params)
 * @method getUploadTokenByParams(array $params)
 */
class GuestPhotoPool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 客片池详情
     *
     * @support  int $photoId 照片id [ require true ]
     * @support  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function photoDetail () {
        return self::getClass()->photoDetail();
    }

    /**
     * 点赞/点踩
     *
     * @support  int $photoId 照片id [ require true ]
     * @support  string $operationType 操作类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function operationPhoto () {
        return self::getClass()->operationPhoto();
    }

    /**
     * 看片完成时批量保存客片
     *
     * @support  string $orderNum 订单号 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveGuestPhoto () {
        return self::getClass()->saveGuestPhoto();
    }

    /**
     * 摄影上传时保存客片
     *
     * @support  string $orderNum 订单号 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveGuestPhotoByUpload () {
        return self::getClass()->saveGuestPhotoByUpload();
    }

    /**
     * hook流水－摄影问题标签
     *
     * @param  string $streamNum 流水num [ require true ]
     * @param  int $photoCount 照片数 [ require true ]
     * @param  array $tags 问题标签 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bmsHookStreamProblemTagPhotography (string $streamNum, int $photoCount, array $tags) {
        return self::getClass()->bmsHookStreamProblemTagPhotography([
            "streamNum" => $streamNum,
            "photoCount" => $photoCount,
            "tags" => $tags,
        ]);
    }

    /**
     * hook流水－化妆问题标签
     *
     * @support  int $streamId 流水id [ require true ]
     * @param  string $streamNum 流水num [ require true ]
     * @param  int $photoCount 照片数 [ require true ]
     * @param  array $tags 问题标签 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bmsHookStreamProblemTagMakeup (string $streamNum, int $photoCount, array $tags) {
        return self::getClass()->bmsHookStreamProblemTagMakeup([
            "streamNum" => $streamNum,
            "photoCount" => $photoCount,
            "tags" => $tags,
        ]);
    }

    /**
     * 客片池列表
     *
     * @support  string $startTime 开始时间 [ require true ]
     * @support  string $endTime 结束时间 [ require true ]
     * @support  string $orderNum 订单号 require false
     * @support  array $photoType 照片类型 require false
     * @support  string $userName 姓名 require false
     * @support  string $phone 手机号 require false
     * @support  array $storeIds 门店id require false
     * @support  array $productIds 产品ids require false
     * @support  array $problemTags 问题标签id require false
     * @support  array $staffs 伙伴信息 require false
     * @support  array $staffInfo 职能信息 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhotoList () {
        return self::getClass()->getPhotoList();
    }

    /**
     * 根据当前图片找到相似图片
     *
     * @param  string $img_url 当前图片地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSimilarByImg (string $img_url) {
        return self::getClass()->getSimilarByImg([
            "img_url" => $img_url,
        ]);
    }

    /**
     * 根据当前图片地址找到对应订单
     *
     * @param  string $img_url 当前图片地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderDetailByImg (string $img_url) {
        return self::getClass()->getOrderDetailByImg([
            "img_url" => $img_url,
        ]);
    }

    /**
     * 获取上传签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUploadToken () {
        return self::getClass()->getUploadToken();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\GuestPhotoPool');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\GuestPhotoPool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}