<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addChartLetByParams(array $params)
 * @method chartLetListByParams(array $params)
 * @method updateChartLetByParams(array $params)
 * @method changeStatusByParams(array $params)
 * @method deletedByParams(array $params)
 * @method infoByParams(array $params)
 */
class ChartLet {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加贴图
     *
     * @support  array $materials 素材信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addChartLet () {
        return self::getClass()->addChartLet();
    }

    /**
     * 贴图素材列表
     *
     * @support  int $page 页码 
     * @support  int $pageSize 分页数 
     * @support  string $range 使用范围 
     * @support  string $brand 品牌 
     * @support  int $productId 产品id 
     * @support  string $status 状态:on,off 
     * @support  string $materialType 素材类别 
     * @throws  \Exception
     * @return  mixed
     */
    public static function chartLetList () {
        return self::getClass()->chartLetList();
    }

    /**
     * 编辑贴图
     *
     * @support  int $id 贴图id [ require true ]
     * @support  string $range 使用范围 
     * @support  string $name 贴图名称 
     * @support  string $brand 页码 
     * @support  int $productId 产品id 
     * @support  string $materialType 素材类别 
     * @support  array $tags 标签ids 
     * @support  string $startTime 产品id 
     * @support  string $endTime 产品id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateChartLet () {
        return self::getClass()->updateChartLet();
    }

    /**
     * 更改素材状态
     *
     * @support  int $materialId 贴图id [ require true ]
     * @support  string $status 启用状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStatus () {
        return self::getClass()->changeStatus();
    }

    /**
     * 删除贴图素材
     *
     * @support  int $materialId 贴图id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleted () {
        return self::getClass()->deleted();
    }

    /**
     * 素材详情
     *
     * @support  int $materialId 贴图id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function info () {
        return self::getClass()->info();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ChartLet');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ChartLet');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}