<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createActiveByParams(array $params)
 * @method searchActiveByParams(array $params)
 * @method copyActivityPageByIdByParams(array $params)
 * @method searchByIdByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method startApprovalByParams(array $params)
 * @method upDownActivePageByParams(array $params)
 * @method approvalHookByParams(array $params)
 * @method cronOfflineActivityByParams(array $params)
 * @method tempAdjustActivityChannelByParams(array $params)
 */
class ActivityPage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建一个活动
     *
     * @support  string $category 分类 [ require true ]
     * @support  string $name 活动名称 [ require true ]
     * @support  string $template 模板key [ require true ]
     * @support  array $extend 扩展信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createActive () {
        return self::getClass()->createActive();
    }

    /**
     * 活动查询
     *
     * @support  string $category 分类 
     * @support  string $name 活动名称 
     * @support  string $template 模板key 
     * @support  int $page 页码 
     * @support  int $page_size 每页数量 
     * @support  bool $all 是否返回所有结果 
     * @throws  \Exception
     * @return  array
     */
    public static function searchActive () {
        return self::getClass()->searchActive();
    }

    /**
     * 复制单个活动
     *
     * @support  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function copyActivityPageById () {
        return self::getClass()->copyActivityPageById();
    }

    /**
     * 单个活动查询
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchById (string $_id) {
        return self::getClass()->searchById([
            "_id" => $_id,
        ]);
    }

    /**
     * 更新活动
     *
     * @support  string $_id id [ require true ]
     * @support  string $category 分类 
     * @support  string $name 活动名称 
     * @support  string $template 模板key 
     * @support  int $auditor 审核者 
     * @support  array $extend 扩展信息 
     * @support  string $link 活动页面链接 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 删除活动
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * 活动申请上线（进入钉钉审批流程）
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function startApproval (string $_id) {
        return self::getClass()->startApproval([
            "_id" => $_id,
        ]);
    }

    /**
     * 上线或下线活动
     *
     * @param  string $_id id [ require true ]
     * @param  string $page_state 页面上线状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upDownActivePage (string $_id, string $page_state) {
        return self::getClass()->upDownActivePage([
            "_id" => $_id,
            "page_state" => $page_state,
        ]);
    }

    /**
     * 审批事件回调监听
     *
     * @param  string $type 回调类型 [ require true ]
     * @param  string $EventType 事件类型 [ require true ]
     * @support  string $processInstanceId 审批实例id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function approvalHook (string $type, string $EventType) {
        return self::getClass()->approvalHook([
            "type" => $type,
            "EventType" => $EventType,
        ]);
    }

    /**
     * 定时下线活动
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOfflineActivity () {
        return self::getClass()->cronOfflineActivity();
    }

    /**
     * tempAdjustActivityChannel
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function tempAdjustActivityChannel () {
        return self::getClass()->tempAdjustActivityChannel();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ActivityPage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ActivityPage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}