<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method setStarByParams(array $params)
 * @method cancelStarByParams(array $params)
 * @method setAfterSaleByParams(array $params)
 */
class BuyerShow {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 晒单列表
     *
     * @support  string $start_time 提交日期开始时间 
     * @support  string $end_time 提交日期结束时间 
     * @support  int $star_level 星级 
     * @support  string $order_num 订单号 
     * @support  string $phone 手机号查询 
     * @support  int $type 类型 [Original type uint] 
     * @support  string $keyword 关键词 
     * @support  array $product_ids 产品ids 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 条数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 设为精选
     *
     * @support  int $id 买家秀ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setStar () {
        return self::getClass()->setStar();
    }

    /**
     * 取消精选
     *
     * @support  int $id 买家秀ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelStar () {
        return self::getClass()->cancelStar();
    }

    /**
     * 转接售后
     *
     * @support  int $id 买家秀ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setAfterSale () {
        return self::getClass()->setAfterSale();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\BuyerShow');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\BuyerShow');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}