<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method uploadByParams(array $params)
 * @method listByParams(array $params)
 * @method openNextBatchByParams(array $params)
 * @method auditByParams(array $params)
 * @method areaSelectByParams(array $params)
 * @method cronByParams(array $params)
 */
class UnreviewedGuestPhotos {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 授权通过，加入客片审核中
     *
     * @support  int $store_id 店铺id [ require true ]
     * @support  int $order_id 订单id [ require true ]
     * @support  array $images 图片数据[[&#039;photo_id&#039;=&gt;1,&#039;product_id&#039;=&gt;123,&#039;photo_url&#039;=&gt;&#039;123.jgp&#039;,people_num=&gt;1],[&#039;photo_id&#039;=&gt;2,&#039;product_id&#039;=&gt;123,&#039;photo_url&#039;=&gt;&#039;123.jgp&#039;,people_num=&gt;2]] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function upload () {
        return self::getClass()->upload();
    }

    /**
     * 获取客片审核列表
     *
     * @support  array $product_ids 产品ids 
     * @support  int $area_id 区域id 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页条数 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 开启下一批审核
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function openNextBatch () {
        return self::getClass()->openNextBatch();
    }

    /**
     * 客片批量审核
     *
     * @support  array $ids 客片ids [ require true ]
     * @support  array $tags 标签ids 
     * @support  string $result 结果[pass, not_pass] [ require true ]
     * @support  bool $is_photography_action 是否加入摄影动作(true 加入，false不加入) 
     * @throws  \Exception
     * @return  mixed
     */
    public static function audit () {
        return self::getClass()->audit();
    }

    /**
     * 客片审核区域下拉数据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function areaSelect () {
        return self::getClass()->areaSelect();
    }

    /**
     * 前置条件：增加一个事件，每当一个督导审核通过后，触发事件，检查当前批次是否督导全部审核完成，全部完成后，增加一个审核完安成日志。
     * 数据主要是为了记录每个区域专家开始审核的时间，通过该时间来判断什么时候发起DingDing提醒
     * todo:此处假设已经有了该事件，后边补上
     * 需要完成的任务：
     * 1. 检查督导的钉钉提醒及客片逾期批量移除
     * 2. 专家的钉钉提醒及客片逾期移除
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cron () {
        return self::getClass()->cron();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\UnreviewedGuestPhotos');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\UnreviewedGuestPhotos');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}