<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchCreateByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method createLogListByParams(array $params)
 * @method abolishByParams(array $params)
 * @method getLogsByParams(array $params)
 */
class ProductCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 管理端生成产品卡
     *
     * @support  string $title 标题 [ require true ]
     * @support  int $template_id 模板id [Original type uint] [ require true ]
     * @support  int $count 创建数量 [Original type uint] [ require true ]
     * @support  string $apply_in 应用于 
     * @support  int $validity_period 有效期 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate () {
        return self::getClass()->batchCreate();
    }

    /**
     * 获取产品卡列表(分页)
     *
     * @support  int $id 产品卡编号 [Original type uint] 
     * @support  string $mobile 手机号 
     * @support  int $user_id 用户id [Original type uint] 
     * @support  string $status 状态 
     * @support  string $code 兑换码 
     * @support  string $apply_in 应用于 
     * @support  bool $with_template_info 包含卡面信息 
     * @support  int $create_log_id 记录id [Original type uint] 
     * @support  string $created_at_start 创建时间起 
     * @support  string $created_at_end 创建时间止 
     * @support  string $used_at_start 使用时间起 
     * @support  string $used_at_end 使用时间止 
     * @support  int $product_id 适用产品 
     * @support  int $store_id 适用门店 
     * @support  bool $action_scope 是否可以用于升级服务 
     * @support  string $description 描述 
     * @support  int $page 页码 
     * @support  int $page_size 每页条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取兑换码列表(所有)
     *
     * @support  string $mobile 手机号 
     * @support  string $created_at_start 生成时间起 
     * @support  string $created_at_end 生成时间止 
     * @support  string $used_at_start 使用时间起 
     * @support  string $used_at_end 使用时间止 
     * @support  string $status 状态 
     * @support  string $apply_in 应用于 
     * @support  string $code 兑换码 
     * @support  int $create_log_id 创建记录id [Original type uint] 
     * @support  bool $with_template_info 包含卡面信息 
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 产品券渠道领券查询
     *
     * @support  int $channel 渠道号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createLogList () {
        return self::getClass()->createLogList();
    }

    /**
     * 作废产品卡
     *
     * @support  array $codes 码数组 
     * @support  array $ids ids数组 
     * @throws  \Exception
     * @return  mixed
     */
    public static function abolish () {
        return self::getClass()->abolish();
    }

    /**
     * 产品券创建记录查询
     *
     * @support  array $ids 记录ids [Original type array&lt;int&gt;] 
     * @support  string $created_at_end 创建时间止 
     * @support  string $created_at_start 创建时间起 
     * @support  bool $with_template_info 包含模板信息 
     * @support  int $page 页码 
     * @support  int $page_size 每页条数 
     * @support  string $apply_in 应用于 
     * @throws  \Exception
     * @return  array
     */
    public static function getLogs () {
        return self::getClass()->getLogs();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}