<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method treeByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method addByParams(array $params)
 * @method editByParams(array $params)
 * @method startByParams(array $params)
 * @method closeByParams(array $params)
 * @method getTopTagByParams(array $params)
 */
class PictureTags {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 标签搜索
     *
     * @support  bool $with_delete 是否包含删除数据 
     * @support  int $id 标签id(查询该标签及所有子级标签) 
     * @support  string $use_type 使用类型，默认样片池标签 
     * @throws  \Exception
     * @return  mixed
     */
    public static function tree () {
        return self::getClass()->tree();
    }

    /**
     * 标签列表
     *
     * @support  int $id 标签id 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页条数 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 标签列表
     *
     * @support  int $id 标签id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 标签添加
     *
     * @support  int $parent_id 标签归属（父级id） 
     * @support  string $name 标签名称 [ require true ]
     * @support  int $weight 权重 [ require true ]
     * @support  string $description 描述 
     * @throws  \Exception
     * @return  mixed
     */
    public static function add () {
        return self::getClass()->add();
    }

    /**
     * 标签修改
     *
     * @support  int $id 标签id [ require true ]
     * @support  int $parent_id 标签归属（父级id） 
     * @support  string $name 标签名称 [ require true ]
     * @support  int $weight 权重 [ require true ]
     * @support  string $description 描述 
     * @throws  \Exception
     * @return  mixed
     */
    public static function edit () {
        return self::getClass()->edit();
    }

    /**
     * 标签启用
     *
     * @support  int $id 标签id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function start () {
        return self::getClass()->start();
    }

    /**
     * 标签停用
     *
     * @support  int $id 标签id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close () {
        return self::getClass()->close();
    }

    /**
     * 获得一级标签
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTopTag () {
        return self::getClass()->getTopTag();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\PictureTags');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\PictureTags');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}