<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method uploadByParams(array $params)
 * @method listByParams(array $params)
 * @method auditByParams(array $params)
 * @method areaSelectByParams(array $params)
 */
class UnreviewedGuestPhotos {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 授权通过，加入客片审核中
     *
     * @support  int $store_id 店铺id [ require true ]
     * @support  int $order_id 订单id [ require true ]
     * @support  int $product_id 产品id [ require true ]
     * @support  string $expired_at 过期时间 
     * @support  array $images 样片地址 [ require true ]
     * @support  string $evidence 凭证地址 
     * @throws  \Exception
     * @return  mixed
     */
    public static function upload () {
        return self::getClass()->upload();
    }

    /**
     * 获取客片审核列表
     *
     * @support  int $product_id 产品id 
     * @support  int $area_id 区域id 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页条数 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 客片批量审核
     *
     * @support  array $ids 客片ids [ require true ]
     * @support  array $tags 标签ids 
     * @support  string $result 结果[pass, not_pass] [ require true ]
     * @support  bool $is_photography_action 是否加入摄影动作(true 加入，false不加入) 
     * @throws  \Exception
     * @return  mixed
     */
    public static function audit () {
        return self::getClass()->audit();
    }

    /**
     * 客片审核区域下拉数据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function areaSelect () {
        return self::getClass()->areaSelect();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\UnreviewedGuestPhotos');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\UnreviewedGuestPhotos');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}