<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method executeDownByParams(array $params)
 * @method executeUpByParams(array $params)
 */
class SamplePools {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 样片池列表
     *
     * @support  string $brand 品牌 
     * @support  int $product_id 产品id 
     * @support  int $type 样片类型 
     * @support  int $uper 上传人 
     * @support  int $tag 相关标签 
     * @support  int $expired_at 到期时间 
     * @support  string $status 样片状态 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页条数 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 样片池详情
     *
     * @support  string $id id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 下架样片
     *
     * @support  int $id 样片id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function executeDown () {
        return self::getClass()->executeDown();
    }

    /**
     * 重新上架样片
     *
     * @support  int $id 样片id [ require true ]
     * @support  array $tags 相关标签 [ require true ]
     * @support  string $expired_at 到期时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function executeUp () {
        return self::getClass()->executeUp();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\SamplePools');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\SamplePools');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}