<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getAllBannerModuleByParams(array $params)
 * @method getBannerTreeByParams(array $params)
 */
class Banner {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * banner列表
     *
     * @support  int $current_city 当前城市id [Original type uint] 
     * @support  string $module 所属品牌 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 创建banner
     *
     * @support  string $title 标题 
     * @support  array $except_city 不展示的城市 
     * @support  array $limit_city 仅限城市 
     * @support  string $img_path 图片地址 [ require true ]
     * @support  string $url 跳转地址 
     * @support  int $sequence 序号 
     * @support  string $start 上线时间 
     * @support  string $end 下线时间 
     * @support  string $module 品牌 [ require true ]
     * @support  string $sub_module 子品牌 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取banner信息
     *
     * @param  string $id banner的id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (string $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 修改banner
     *
     * @support  string $id banner的id 
     * @support  string $title 标题 
     * @support  array $except_city 不展示的城市 
     * @support  array $limit_city 仅限城市 
     * @support  string $img_path 图片地址 
     * @support  string $url 跳转地址 
     * @support  int $sequence 序号 
     * @support  string $start 上线时间 
     * @support  string $end 下线时间 
     * @support  string $module 品牌 [ require true ]
     * @support  string $sub_module 子品牌 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 删除banner信息
     *
     * @param  string $id banner的id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 获取所有banner module
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllBannerModule () {
        return self::getClass()->getAllBannerModule();
    }

    /**
     * 获取所有banner tree
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBannerTree () {
        return self::getClass()->getBannerTree();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Banner');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Banner');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}