<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method allByParams(array $params)
 */
class Property {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建属性
     *
     * @param  string $name 名称 [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  array $content 内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name, string $type, array $content) {
        return self::getClass()->create([
            "name" => $name,
            "type" => $type,
            "content" => $content,
        ]);
    }

    /**
     * 修改属性
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @param  string $name 名称 [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  array $content 内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id, string $name, string $type, array $content) {
        return self::getClass()->update([
            "id" => $id,
            "name" => $name,
            "type" => $type,
            "content" => $content,
        ]);
    }

    /**
     * 属性列表
     *
     * @param  string $name 名称 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (string $name = '', int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "name" => $name,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 删除属性
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 所有属性[不分页]
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (string $name = '') {
        return self::getClass()->all([
            "name" => $name,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Retail\Property');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Retail\Property');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}