<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllProductGiftByParams(array $params)
 * @method getAllProductGiftByPageByParams(array $params)
 * @method getProductGiftConfigByParams(array $params)
 * @method getProductGiftRuleByParams(array $params)
 * @method addProductGiftRuleByParams(array $params)
 * @method deleteProductGiftRuleAndGiftConfigByParams(array $params)
 * @method executeRuleByParams(array $params)
 */
class ProductGift {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取零售赠品列表
     *
     * @support  string $name 名称(模糊查询) 
     * @support  int $category_id 分类ID 
     * @support  bool $show_deleted 是否显示已删除信息 
     * @support  string $status 状态 
     * @support  array $store_ids 店铺ids 
     * @support  array $area_ids 城市ids 
     * @support  string $store_type 门店类型 
     * @support  string $from 查询来源 
     * @throws  \Exception
     * @return  array
     */
    public static function getAllProductGift () {
        return self::getClass()->getAllProductGift();
    }

    /**
     * 获取零售产品分页列表
     *
     * @support  string $name 名称(模糊查询) 
     * @support  int $category_id 分类ID 
     * @support  bool $show_Deleted 是否显示已删除信息 
     * @support  string $status 状态 
     * @support  array $store_ids 店铺ids 
     * @support  array $area_ids 城市ids 
     * @support  string $store_type 门店类型 
     * @support  string $from 查询来源 
     * @support  int $page 当前页 
     * @support  int $page_size 页内条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getAllProductGiftByPage () {
        return self::getClass()->getAllProductGiftByPage();
    }

    /**
     * 获取赠品配置信息
     *
     * @support  string $config_name 名称(模糊查询) 
     * @support  int $node_id 节点ID 
     * @support  bool $include_delete 是否显示已删除信息 
     * @support  int $retail_product_id 零售产品id 
     * @support  string $retail_product_name 零售产品名称 
     * @support  string $group 品牌分组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductGiftConfig () {
        return self::getClass()->getProductGiftConfig();
    }

    /**
     * 获取赠品规则
     *
     * @support  int $node_id 节点ID 
     * @support  string $start_at 开始时间 
     * @support  string $end_at 结束时间 
     * @support  string $group 品牌分组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductGiftRule () {
        return self::getClass()->getProductGiftRule();
    }

    /**
     * 编辑多条赠品规则
     *
     * @support  int $node_id 节点ID [ require true ]
     * @support  array $gift_rule_detail 规则详情 [ require true ]
     * @support  string $config_name 名称 [ require true ]
     * @support  array $gift_config_detail 配置详情 [ require true ]
     * @support  string $group 品牌分组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addProductGiftRule () {
        return self::getClass()->addProductGiftRule();
    }

    /**
     * 删除多条赠品规则
     *
     * @param  int $node_id 节点ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteProductGiftRuleAndGiftConfig (int $node_id) {
        return self::getClass()->deleteProductGiftRuleAndGiftConfig([
            "node_id" => $node_id,
        ]);
    }

    /**
     * 发放或查询符合规则的赠品
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  string $mode 模式(query,execute) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function executeRule (int $order_id, string $mode) {
        return self::getClass()->executeRule([
            "order_id" => $order_id,
            "mode" => $mode,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductGift');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductGift');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}