<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Extend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method refreshTokenByParams(array $params)
 * @method getCanModifyOrdersByParams(array $params)
 * @method getCanTransferStoresByParams(array $params)
 * @method getModifyDateByParams(array $params)
 * @method reservationListByParams(array $params)
 * @method modifyReserveTimeByParams(array $params)
 * @method transferStoreByParams(array $params)
 * @method createTicketByParams(array $params)
 * @method addTicketEvaluationByParams(array $params)
 * @method ticketCallbackByParams(array $params)
 * @method getSatisfactionLevelLabelsByParams(array $params)
 */
class ZhiChi {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 每天早上9点喝24点刷新
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function refreshToken () {
        return self::getClass()->refreshToken();
    }

    /**
     * 获取可修改预约时间/可转门店的订单列表
     *
     * @param  string $partnerId openId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCanModifyOrders (string $partnerId) {
        return self::getClass()->getCanModifyOrders([
            "partnerId" => $partnerId,
        ]);
    }

    /**
     * 获取可转门店列表
     *
     * @param  string $partnerId openId [ require true ]
     * @param  int $orderId 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCanTransferStores (string $partnerId, int $orderId) {
        return self::getClass()->getCanTransferStores([
            "partnerId" => $partnerId,
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取修改的日期
     *
     * @param  string $partnerId openId [ require true ]
     * @param  int $storeId 门店id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getModifyDate (string $partnerId, int $storeId) {
        return self::getClass()->getModifyDate([
            "partnerId" => $partnerId,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取排单表占点
     *
     * @param  string $partnerId openid [ require true ]
     * @param  int $orderId 订单id [Original type uint] [ require true ]
     * @param  int $storeId 门店id [Original type uint] [ require true ]
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reservationList (string $partnerId, int $orderId, int $storeId, string $date) {
        return self::getClass()->reservationList([
            "partnerId" => $partnerId,
            "orderId" => $orderId,
            "storeId" => $storeId,
            "date" => $date,
        ]);
    }

    /**
     * 修改预约时间
     *
     * @param  string $partnerId openid [ require true ]
     * @param  string $reserveTime 预约时间 [ require true ]
     * @param  int $orderId 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function modifyReserveTime (string $partnerId, int $orderId, string $reserveTime) {
        return self::getClass()->modifyReserveTime([
            "partnerId" => $partnerId,
            "orderId" => $orderId,
            "reserveTime" => $reserveTime,
        ]);
    }

    /**
     * 转门店
     *
     * @param  string $partnerId openId [ require true ]
     * @param  int $orderId 订单id [Original type uint] [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $reserveTime 预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function transferStore (string $partnerId, int $orderId, int $storeId, string $reserveTime) {
        return self::getClass()->transferStore([
            "partnerId" => $partnerId,
            "orderId" => $orderId,
            "storeId" => $storeId,
            "reserveTime" => $reserveTime,
        ]);
    }

    /**
     * 创建工单
     *
     * @param  int $share_order_id 晒单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createTicket (int $share_order_id) {
        return self::getClass()->createTicket([
            "share_order_id" => $share_order_id,
        ]);
    }

    /**
     * 提交工单满意度
     *
     * @param  string $ticket_id 工单id [ require true ]
     * @param  int $score 评分 [Original type uint] [ require true ]
     * @param  string $remark 评语 [ require true ]
     * @param  array $labels 标记 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addTicketEvaluation (string $ticket_id, int $score, string $remark = '', array $labels = []) {
        return self::getClass()->addTicketEvaluation([
            "ticket_id" => $ticket_id,
            "score" => $score,
            "remark" => $remark,
            "labels" => $labels,
        ]);
    }

    /**
     * 工单消息回调
     *
     * @support  string $sys_code 产品编码 [ require true ]
     * @support  string $type 消息类型 [ require true ]
     * @support  array $content 消息内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function ticketCallback () {
        return self::getClass()->ticketCallback();
    }

    /**
     * 获取满意度的标签
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSatisfactionLevelLabels () {
        return self::getClass()->getSatisfactionLevelLabels();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Extend\ZhiChi');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Extend\ZhiChi');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}