<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method listWithParamsByParams(array $params)
 * @method detailByParams(array $params)
 * @method getListByPayByParams(array $params)
 */
class GroupOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 团购订单列表
     *
     * @support  string $business_name 企业名称 
     * @support  string $user_name 联系人 
     * @support  string $user_phone 手机号 
     * @support  array $order_ids 订单ids 
     * @support  string $order_no 订单号 
     * @support  string $status 订单状态 
     * @support  int $is_private_pay 是否垫付(-1:非垫付，1：垫付) 
     * @support  int $is_installment 是否分期(-1:全款，1：分期) 
     * @support  string $installment_status 分期付款状态 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 团购订单列表
     *
     * @param  array $params params [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function listWithParams (array $params) {
        return self::getClass()->listWithParams([
            "params" => $params,
        ]);
    }

    /**
     * 订单详情
     *
     * @param  int $id 订单id [ require true ]
     * @param  string $group_order_type 券码类型/产品类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id, string $group_order_type = '') {
        return self::getClass()->detail([
            "id" => $id,
            "group_order_type" => $group_order_type,
        ]);
    }

    /**
     * 根据支付方式获取订单列表
     *
     * @support  string $pay_type 支付类型，同子订单支付类型 
     * @support  string $paid_at_start 支付时间开始 
     * @support  string $paid_at_end 支付时间结束 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getListByPay () {
        return self::getClass()->getListByPay();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\GroupOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\GroupOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}