<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method allByParams(array $params)
 * @method detailByParams(array $params)
 * @method updateByParams(array $params)
 */
class SubscribeCardPackage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订阅卡包
     *
     * @support  string $name 名称 [ require true ]
     * @support  string $desc 卡包描述 [ require true ]
     * @support  array $product_templates 产品模板 [ require true ]
     * @support  array $shops 允许的店铺 [ require true ]
     * @support  int $status 开启状态:0-开启1-关闭 
     * @support  int $period_of_validity 有效期:0-半年,1-一年,2-两年,3-三年 
     * @support  float $price 售卖价格 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function add () {
        return self::getClass()->add();
    }

    /**
     * 订阅卡包列表
     *
     * @support  string $name 订阅卡包名称 
     * @support  int $page 分页 [Original type uint] 
     * @support  int $page_size 每页数据条数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 订阅卡包详情
     *
     * @support  int $id ID 
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 更新订阅卡包
     *
     * @support  string $name 名称 
     * @support  string $desc 卡包描述 
     * @support  array $product_templates 产品模板 
     * @support  array $shops 允许的店铺 
     * @support  int $status 开启状态:0-开启1-关闭 
     * @support  int $period_of_validity 有效期:0-半年,1-一年,2-两年,3-三年 
     * @support  float $price 售卖价格 [Original type double] 
     * @support  int $id ID [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\SubscribeCardPackage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\SubscribeCardPackage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}