<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method deleteByParams(array $params)
 * @method updateByParams(array $params)
 * @method updateStatusByParams(array $params)
 * @method getCategoryChildByParams(array $params)
 * @method getProductCategoryListByParams(array $params)
 * @method getProductCategoryAllByParams(array $params)
 * @method editExtendByParams(array $params)
 * @method getCategoryTreeByParams(array $params)
 * @method setCHiddenStatusByParams(array $params)
 * @method dragCategoryByParams(array $params)
 * @method allClothByParams(array $params)
 * @method createClothByParams(array $params)
 * @method updateClothByParams(array $params)
 * @method deleteClothByParams(array $params)
 */
class Category {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建类目
     *
     * @support  string $name 类目名称 [ require true ]
     * @support  string $module 模块 [ require true ]
     * @support  int $parent_id 父级id [Original type uint] 
     * @support  string $eng_name 英文名称 
     * @support  string $full_name 全称 
     * @support  int $sort 排序 
     * @support  bool $multiple 是否支持多选 
     * @support  array $extend 其他配图 
     * @support  string $status 状态 
     * @support  string $comment 描述 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 产品类目详情
     *
     * @support  int $id 类目id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 删除产品类目
     *
     * @support  int $id 类目id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 更新类目
     *
     * @support  int $id id [ require true ]
     * @support  string $module 模块 [ require true ]
     * @support  string $name 类目名称 [ require true ]
     * @support  int $parent_id 父级id [Original type uint] 
     * @support  string $eng_name 英文名称 
     * @support  string $full_name 全称 
     * @support  int $sort 排序 
     * @support  bool $multiple 是否支持多选 
     * @support  array $extend 其他配图 
     * @support  string $status 状态 
     * @support  string $comment 描述 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 更改类目状态
     *
     * @support  int $id 分类ID [ require true ]
     * @support  string $status 状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function updateStatus () {
        return self::getClass()->updateStatus();
    }

    /**
     * 获取类目所有子集
     *
     * @support  int $id 类目id [Original type uint] [ require true ]
     * @support  string $type 获取方式,树状tree/扁平flat [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCategoryChild () {
        return self::getClass()->getCategoryChild();
    }

    /**
     * 类目列表
     *
     * @support  int $page 当前页 
     * @support  int $page_size 页内条数 
     * @support  string $name 类目名称(支持模糊搜索) 
     * @support  string $full_name 类目全称(支持模糊搜索) 
     * @support  int $parent_id 类目父类id [Original type uint] 
     * @support  bool $show_deleted 是否包含删除 
     * @support  bool $c_hidden 是否预约端隐藏 
     * @support  bool $status 是否上线 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductCategoryList () {
        return self::getClass()->getProductCategoryList();
    }

    /**
     * 类目列表
     *
     * @support  string $name 类目名称(支持模糊搜索) 
     * @support  string $full_name 类目全称(支持模糊搜索) 
     * @support  int $parent_id 类目父类id [Original type uint] 
     * @support  bool $show_deleted 是否包含删除 
     * @support  bool $c_hidden 是否预约端隐藏 
     * @support  bool $status 是否上线 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductCategoryAll () {
        return self::getClass()->getProductCategoryAll();
    }

    /**
     * 修改extend
     *
     * @support  int $id 类目id 
     * @support  array $extend 额外信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editExtend () {
        return self::getClass()->editExtend();
    }

    /**
     * 获取树状类目
     *
     * @support  int $show_level 起始类目等级 
     * @support  string $status 起始类目等级 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCategoryTree () {
        return self::getClass()->getCategoryTree();
    }

    /**
     * 开启/关闭该类目下产品预约端是否显示
     *
     * @param  int $id 类目id [ require true ]
     * @param  bool $c_hidden 预约端是否隐藏 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setCHiddenStatus (int $id, bool $c_hidden) {
        return self::getClass()->setCHiddenStatus([
            "id" => $id,
            "c_hidden" => $c_hidden,
        ]);
    }

    /**
     * 类目拖拽排序
     *
     * @param  int $current_id 当前产品id [ require true ]
     * @param  int $target_parent_id 目标位置父级id [ require true ]
     * @param  int $target_sort 目标位置排序值 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function dragCategory (int $current_id, int $target_parent_id, int $target_sort) {
        return self::getClass()->dragCategory([
            "current_id" => $current_id,
            "target_parent_id" => $target_parent_id,
            "target_sort" => $target_sort,
        ]);
    }

    /**
     * 获取某产品组所有服装
     *
     * @param  int $category_id 产品组id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function allCloth (int $category_id) {
        return self::getClass()->allCloth([
            "category_id" => $category_id,
        ]);
    }

    /**
     * 产品组添加服装
     *
     * @support  int $category_id 产品组id [ require true ]
     * @support  string $gender 性别 [ require true ]
     * @support  string $image 图片地址 [ require true ]
     * @support  int $cloth_group_id 服装分区id 
     * @support  int $sort 排序值 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createCloth () {
        return self::getClass()->createCloth();
    }

    /**
     * 更新服装
     *
     * @param  int $cloth_id 服装id [ require true ]
     * @support  string $gender 性别 
     * @support  string $image 图片地址 
     * @support  int $cloth_group_id 服装分区id 
     * @support  int $sort 排序值 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateCloth (int $cloth_id) {
        return self::getClass()->updateCloth([
            "cloth_id" => $cloth_id,
        ]);
    }

    /**
     * 删除服装
     *
     * @param  int $cloth_id 服装id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteCloth (int $cloth_id) {
        return self::getClass()->deleteCloth([
            "cloth_id" => $cloth_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Category');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Category');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}