<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method samplePhotoExpireNoticeByParams(array $params)
 * @method performanceShotDailyByParams(array $params)
 * @method reservationLogByParams(array $params)
 * @method reservationAnalyzeByParams(array $params)
 * @method reservationChangeByParams(array $params)
 * @method refreshSessionByParams(array $params)
 * @method returnGiftCardByParams(array $params)
 * @method effectCompareByParams(array $params)
 * @method pushPregnantKfMsgByParams(array $params)
 * @method lookPhotoAutoCompleteByParams(array $params)
 * @method pictureOnlineLookPhotoAutoCompleteByParams(array $params)
 * @method upgradeSkuAutoCompleteByParams(array $params)
 * @method sendDingDingNotifyByParams(array $params)
 * @method sevenDayInvigorateByParams(array $params)
 * @method nineTeenInvigorateByParams(array $params)
 * @method longTimeNoBuyInvigorateByParams(array $params)
 * @method chooseClothTipsDayByParams(array $params)
 * @method chooseClothTipsOneHoursByParams(array $params)
 * @method sendAppointmentNoticePushByParams(array $params)
 * @method sendWxChooseClothTipsByParams(array $params)
 * @method autoDealRefundByParams(array $params)
 * @method autoCheckRefundHasInvoiceByParams(array $params)
 */
class Cron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 每天10点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function samplePhotoExpireNotice () {
        return self::getClass()->samplePhotoExpireNotice();
    }

    /**
     * 每天2点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function performanceShotDaily () {
        return self::getClass()->performanceShotDaily();
    }

    /**
     * 每天1点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reservationLog () {
        return self::getClass()->reservationLog();
    }

    /**
     * 每天0点5分执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reservationAnalyze () {
        return self::getClass()->reservationAnalyze();
    }

    /**
     * 每天11点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reservationChange () {
        return self::getClass()->reservationChange();
    }

    /**
     * 每月的1号15号2点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function refreshSession () {
        return self::getClass()->refreshSession();
    }

    /**
     * 未接受礼品卡退还
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function returnGiftCard () {
        return self::getClass()->returnGiftCard();
    }

    /**
     * 每天9点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function effectCompare () {
        return self::getClass()->effectCompare();
    }

    /**
     * 每天18点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushPregnantKfMsg () {
        return self::getClass()->pushPregnantKfMsg();
    }

    /**
     * 每天13点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function lookPhotoAutoComplete () {
        return self::getClass()->lookPhotoAutoComplete();
    }

    /**
     * 每天13点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function pictureOnlineLookPhotoAutoComplete () {
        return self::getClass()->pictureOnlineLookPhotoAutoComplete();
    }

    /**
     * 每天13点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function upgradeSkuAutoComplete () {
        return self::getClass()->upgradeSkuAutoComplete();
    }

    /**
     * 每天10点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendDingDingNotify () {
        return self::getClass()->sendDingDingNotify();
    }

    /**
     * 登陆7天后,用户未下单,促活用户
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sevenDayInvigorate () {
        return self::getClass()->sevenDayInvigorate();
    }

    /**
     * 登陆19天后,用户未下单,促活用户
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function nineTeenInvigorate () {
        return self::getClass()->nineTeenInvigorate();
    }

    /**
     * 最后一次消费超过192天,用户没有再次下单,促活用户
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function longTimeNoBuyInvigorate () {
        return self::getClass()->longTimeNoBuyInvigorate();
    }

    /**
     * 拍前选衣-提前24小时 发送未拍前选衣的提醒
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function chooseClothTipsDay () {
        return self::getClass()->chooseClothTipsDay();
    }

    /**
     * 拍前选衣-(用户创建时间和拍摄时间&lt; 24 小时，提前一天发送拍前选衣提醒)发送未拍前选衣的提醒
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function chooseClothTipsOneHours () {
        return self::getClass()->chooseClothTipsOneHours();
    }

    /**
     * 发送预约提醒消息
     *
     * @support  string $title 标题 [ require true ]
     * @support  array $userInfo 用户信息 [ require true ]
     * @support  array $storeInfo 门店信息 [ require true ]
     * @support  array $orderInfo 订单信息 [ require true ]
     * @support  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendAppointmentNoticePush () {
        return self::getClass()->sendAppointmentNoticePush();
    }

    /**
     * 发送拍前选衣提醒消息
     *
     * @support  array $orderInfo 订单信息 [ require true ]
     * @support  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendWxChooseClothTips () {
        return self::getClass()->sendWxChooseClothTips();
    }

    /**
     * 每月2号处理月末月初的退款
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoDealRefund () {
        return self::getClass()->autoDealRefund();
    }

    /**
     * 检查退款中是否存在冲红成功的
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoCheckRefundHasInvoice () {
        return self::getClass()->autoCheckRefundHasInvoice();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\Cron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\Cron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}