<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getKidsProductByParams(array $params)
 * @method getRecommendProductByParams(array $params)
 * @method productSearchByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 通过id获取kids产品 近一年没有调用,前端排查没有使用， 下次删除，前端说不用了
     *
     * @param  int $product_id kids产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getKidsProduct (int $product_id) {
        return self::getClass()->getKidsProduct([
            "product_id" => $product_id,
        ]);
    }

    /**
     * 获取推荐产品/产品组 预约端已经不再使用, 日志尚有调用记录
     *
     * @param  int $category_id 要配置的类目ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRecommendProduct (int $category_id) {
        return self::getClass()->getRecommendProduct([
            "category_id" => $category_id,
        ]);
    }

    /**
     * 产品搜索
     *
     * @support  string $name 搜索名称 [ require true ]
     * @support  int $city_id 城市id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productSearch () {
        return self::getClass()->productSearch();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}